/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker;

import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.furnace.proxy.Proxies;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;

public class GetAllFreeMarkerMethodsMethod
implements WindupFreeMarkerMethod {
    @Inject
    private Imported<WindupFreeMarkerMethod> methods;

    @Override
    public String getDescription() {
        return "This method takes no parameters, and returns a List of hashes containing a 'name', 'description', and 'class' field.";
    }

    public Object exec(List arguments) throws TemplateModelException {
        ArrayList results = new ArrayList();
        for (WindupFreeMarkerMethod method : this.methods) {
            HashMap<String, String> methodInfo = new HashMap<String, String>();
            methodInfo.put("name", method.getMethodName());
            methodInfo.put("description", method.getDescription());
            methodInfo.put("class", Proxies.unwrapProxyClassName(method.getClass()));
            results.add(methodInfo);
        }
        return results;
    }
}

