/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.service;

import com.tinkerpop.gremlin.java.GremlinPipeline;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;
import org.jboss.windup.config.AbstractRuleLifecycleListener;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.RuleLifecycleListener;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.model.ClassificationModel;

class ClassificationServiceCache
extends AbstractRuleLifecycleListener
implements RuleLifecycleListener {
    ClassificationServiceCache() {
    }

    private static synchronized Map<String, Boolean> getCache(GraphRewrite event) {
        Map result = (Map)event.getRewriteContext().get(ClassificationServiceCache.class);
        if (result == null) {
            result = Collections.synchronizedMap(new LRUMap(30000));
            event.getRewriteContext().put(ClassificationServiceCache.class, result);
        }
        return result;
    }

    static boolean isClassificationLinkedToFileModel(GraphRewrite event, ClassificationModel classificationModel, FileModel fileModel) {
        String key = ClassificationServiceCache.getClassificationFileModelCacheKey(classificationModel, fileModel);
        Boolean linked = ClassificationServiceCache.getCache(event).get(key);
        if (linked == null) {
            GremlinPipeline existenceCheck = new GremlinPipeline((Object)classificationModel.asVertex());
            existenceCheck.out(new String[]{"ClassificationModel:classificationModelToFileModel"});
            existenceCheck.retain(Collections.singleton(fileModel.asVertex()));
            linked = existenceCheck.iterator().hasNext();
            ClassificationServiceCache.cacheClassificationFileModel(event, classificationModel, fileModel, linked);
        }
        return linked;
    }

    static void cacheClassificationFileModel(GraphRewrite event, ClassificationModel classificationModel, FileModel fileModel, boolean linked) {
        String key = ClassificationServiceCache.getClassificationFileModelCacheKey(classificationModel, fileModel);
        ClassificationServiceCache.getCache(event).put(key, linked);
    }

    private static String getClassificationFileModelCacheKey(ClassificationModel classificationModel, FileModel fileModel) {
        StringBuilder builder = new StringBuilder();
        if (classificationModel != null) {
            builder.append(classificationModel.asVertex().getId());
        }
        builder.append("_");
        if (fileModel != null) {
            builder.append(fileModel.asVertex().getId());
        }
        return builder.toString();
    }

    public void beforeExecution(GraphRewrite event) {
        ClassificationServiceCache.getCache(event).clear();
    }

    public void afterExecution(GraphRewrite event) {
        ClassificationServiceCache.getCache(event).clear();
    }
}

