/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.maven.model.building.ModelSource2;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.furnace.util.Assert;

public class FileResourceModelSource
implements ModelSource2 {
    private final FileResource<?> fileResource;

    public FileResourceModelSource(FileResource<?> fileResource) {
        Assert.notNull(fileResource, (String)"POM Resource may not be null");
        this.fileResource = fileResource;
    }

    public InputStream getInputStream() throws IOException {
        return this.fileResource.getResourceInputStream();
    }

    public String getLocation() {
        return ((File)this.fileResource.getUnderlyingResourceObject()).getPath();
    }

    public ModelSource2 getRelatedSource(String relPath) {
        relPath = relPath.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        FileResource relatedPom = (FileResource)this.fileResource.getParent().getChild(relPath).reify(FileResource.class);
        if (relatedPom != null && relatedPom.isDirectory()) {
            relatedPom = (FileResource)relatedPom.getChild("pom.xml").reify(FileResource.class);
        }
        if (relatedPom != null && relatedPom.exists()) {
            return new FileResourceModelSource(relatedPom);
        }
        return null;
    }

    public URI getLocationURI() {
        return ((File)this.fileResource.getUnderlyingResourceObject()).toURI();
    }
}

