/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.projects;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.jboss.forge.addon.environment.Environment;
import org.jboss.forge.addon.maven.environment.Network;
import org.jboss.forge.addon.maven.impl.DefaultModelCache;
import org.jboss.forge.addon.maven.impl.FileResourceModelSource;
import org.jboss.forge.addon.maven.impl.MavenModelResolver;
import org.jboss.forge.addon.maven.profiles.ProfileAdapter;
import org.jboss.forge.addon.maven.projects.PlexusContainer;
import org.jboss.forge.addon.maven.projects.util.RepositoryUtils;
import org.jboss.forge.addon.maven.resources.MavenModelResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.monitor.ResourceMonitor;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.manager.maven.MavenContainer;
import org.jboss.forge.furnace.manager.maven.util.MavenRepositories;
import org.jboss.forge.furnace.util.Assert;

public class MavenBuildManager {
    private Map<String, ProjectBuildingResult> cacheProject = new WeakHashMap<String, ProjectBuildingResult>();
    private ProjectBuilder projectBuilder;
    private PlexusContainer plexus;
    private Map<String, ModelBuildingResult> cacheModel = new WeakHashMap<String, ModelBuildingResult>();
    private ModelBuilder modelBuilder;
    private MavenContainer container = new MavenContainer();
    private Environment environment;

    public ModelBuildingResult getModelBuildingResult(MavenModelResource pomResource) throws ModelBuildingException {
        ModelBuildingResult result = this.cacheModel.get(pomResource.getFullyQualifiedName());
        if (result == null) {
            boolean inTransaction;
            ModelBuilder builder = this.getModelBuilder();
            DefaultModelBuildingRequest request = this.getModelBuildingRequest();
            boolean bl = inTransaction = !((File)pomResource.getUnderlyingResourceObject()).exists();
            if (inTransaction) {
                request.setModelSource((ModelSource)new FileResourceModelSource((FileResource<?>)pomResource));
            } else {
                request.setPomFile((File)pomResource.getUnderlyingResourceObject());
                this.monitorResource(pomResource);
            }
            result = builder.build((ModelBuildingRequest)request);
            this.cacheModel.put(pomResource.getFullyQualifiedName(), result);
        }
        return result;
    }

    ProjectBuildingResult getProjectBuildingResult(MavenModelResource pomResource) throws ProjectBuildingException {
        ProjectBuildingResult result = this.cacheProject.get(pomResource.getFullyQualifiedName());
        if (result == null) {
            try {
                boolean inTransaction;
                ProjectBuildingRequest request = this.getProjectBuildingRequest();
                Assert.notNull((Object)request, (String)"Project building request was null");
                request.setResolveDependencies(true);
                boolean bl = inTransaction = !((File)pomResource.getUnderlyingResourceObject()).exists();
                if (inTransaction) {
                    result = this.getProjectBuilder().build((ModelSource)new FileResourceModelSource((FileResource<?>)pomResource), request);
                } else {
                    result = this.getProjectBuilder().build((File)pomResource.getUnderlyingResourceObject(), request);
                    this.monitorResource(pomResource);
                }
            }
            catch (ProjectBuildingException pbe) {
                List results = pbe.getResults();
                if (results != null && results.size() > 0) {
                    result = (ProjectBuildingResult)results.get(0);
                }
                throw pbe;
            }
            finally {
                if (result != null) {
                    this.cacheProject.put(pomResource.getFullyQualifiedName(), result);
                }
            }
        }
        return result;
    }

    private void monitorResource(MavenModelResource pomResource) {
        ResourceMonitor monitor = pomResource.monitor();
        monitor.addResourceListener(event -> {
            this.evictFromCache(pomResource);
            monitor.cancel();
        });
    }

    @Deprecated
    ProjectBuildingRequest getProjectBuildingRequest() {
        return this.getProjectBuildingRequest(Network.isOffline((Environment)this.getEnvironment()));
    }

    private DefaultModelBuildingRequest getModelBuildingRequest() {
        Settings settings = this.container.getSettings();
        RepositorySystem system = this.container.getRepositorySystem();
        DefaultRepositorySystemSession session = this.container.setupRepoSession(system, settings);
        List remoteRepositories = MavenRepositories.getRemoteRepositories((MavenContainer)this.container, (Settings)settings);
        MavenModelResolver resolver = new MavenModelResolver(system, (RepositorySystemSession)session, remoteRepositories);
        DefaultModelBuildingRequest request = new DefaultModelBuildingRequest().setSystemProperties(System.getProperties()).setModelResolver((ModelResolver)resolver).setLocationTracking(true).setModelCache(DefaultModelCache.newInstance((RepositorySystemSession)session)).setProfiles(settings.getProfiles().stream().map(ProfileAdapter::new).collect(Collectors.toList())).setActiveProfileIds(settings.getActiveProfiles());
        return request;
    }

    private ProjectBuildingRequest getProjectBuildingRequest(boolean offline) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Settings settings = this.container.getSettings();
            DefaultMavenExecutionRequest executionRequest = new DefaultMavenExecutionRequest();
            MavenExecutionRequestPopulator populator = this.getPlexus().lookup(MavenExecutionRequestPopulator.class);
            populator.populateFromSettings((MavenExecutionRequest)executionRequest, this.container.getSettings());
            populator.populateDefaults((MavenExecutionRequest)executionRequest);
            RepositorySystem system = this.getPlexus().lookup(RepositorySystem.class);
            ProjectBuildingRequest request = executionRequest.getProjectBuildingRequest();
            ArtifactRepository localRepository = RepositoryUtils.toArtifactRepository("local", new File(settings.getLocalRepository()).toURI().toURL().toString(), null, true, true);
            request.setLocalRepository(localRepository);
            ArrayList<ArtifactRepository> settingsRepos = new ArrayList<ArtifactRepository>(request.getRemoteRepositories());
            List activeProfiles = settings.getActiveProfiles();
            Map profiles = settings.getProfilesAsMap();
            for (String id : activeProfiles) {
                Profile profile = (Profile)profiles.get(id);
                if (profile == null) continue;
                List repositories = profile.getRepositories();
                for (Repository repository : repositories) {
                    settingsRepos.add(RepositoryUtils.convertFromMavenSettingsRepository(repository));
                }
            }
            request.setRemoteRepositories(settingsRepos);
            request.setSystemProperties(System.getProperties());
            DefaultRepositorySystemSession repositorySession = MavenRepositorySystemUtils.newSession();
            Proxy activeProxy = settings.getActiveProxy();
            if (activeProxy != null) {
                DefaultProxySelector dps = new DefaultProxySelector();
                dps.add(RepositoryUtils.convertFromMavenProxy(activeProxy), activeProxy.getNonProxyHosts());
                repositorySession.setProxySelector((ProxySelector)dps);
            }
            LocalRepository localRepo = new LocalRepository(settings.getLocalRepository());
            repositorySession.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)repositorySession, localRepo));
            repositorySession.setOffline(offline);
            List mirrors = executionRequest.getMirrors();
            if (mirrors != null) {
                DefaultMirrorSelector mirrorSelector = new DefaultMirrorSelector();
                for (Mirror mirror : mirrors) {
                    mirrorSelector.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
                }
                repositorySession.setMirrorSelector((MirrorSelector)mirrorSelector);
            }
            request.setRepositorySession((RepositorySystemSession)repositorySession);
            request.setProcessPlugins(false);
            request.setResolveDependencies(false);
            ProjectBuildingRequest projectBuildingRequest = request;
            return projectBuildingRequest;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create Maven project building request", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private ModelBuilder getModelBuilder() {
        if (this.modelBuilder == null) {
            this.modelBuilder = new DefaultModelBuilderFactory().newInstance();
        }
        return this.modelBuilder;
    }

    private ProjectBuilder getProjectBuilder() {
        if (this.projectBuilder == null) {
            this.projectBuilder = this.getPlexus().lookup(ProjectBuilder.class);
        }
        return this.projectBuilder;
    }

    File getLocalRepositoryDirectory() {
        return new File(this.container.getSettings().getLocalRepository()).getAbsoluteFile();
    }

    void evictFromCache(MavenModelResource pom) {
        String key = pom.getFullyQualifiedName();
        this.cacheProject.remove(key);
        this.cacheModel.remove(key);
    }

    private PlexusContainer getPlexus() {
        if (this.plexus == null) {
            this.plexus = (PlexusContainer)((Object)SimpleContainer.getServices((ClassLoader)this.getClass().getClassLoader(), PlexusContainer.class).get());
        }
        return this.plexus;
    }

    private Environment getEnvironment() {
        if (this.environment == null) {
            this.environment = (Environment)SimpleContainer.getServices((ClassLoader)this.getClass().getClassLoader(), Environment.class).get();
        }
        return this.environment;
    }
}

