/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.mavenize;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.apache.commons.collections4.OrderedMap;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.OrganizationModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.TechnologyReferenceModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.rules.apps.java.archives.model.ArchiveCoordinateModel;
import org.jboss.windup.rules.apps.java.archives.model.IdentifiedArchiveModel;
import org.jboss.windup.rules.apps.mavenize.Dependency;
import org.jboss.windup.rules.apps.mavenize.FeatureBasedApiDependenciesDeducer;
import org.jboss.windup.rules.apps.mavenize.GlobalBomModel;
import org.jboss.windup.rules.apps.mavenize.MavenCoord;
import org.jboss.windup.rules.apps.mavenize.MavenStructureRenderer;
import org.jboss.windup.rules.apps.mavenize.MavenizeRuleProvider;
import org.jboss.windup.rules.apps.mavenize.ModuleAnalysisHelper;
import org.jboss.windup.rules.apps.mavenize.Pom;
import org.jboss.windup.rules.apps.mavenize.SimpleDependency;
import org.jboss.windup.util.Logging;

public class MavenizationService {
    private static final Logger LOG = Logging.get(MavenizationService.class);
    public static final String OUTPUT_SUBDIR_MAVENIZED = "mavenized";
    private final GraphContext grCtx;

    MavenizationService(GraphContext graphContext) {
        this.grCtx = graphContext;
    }

    void mavenizeApp(ProjectModel projectModel) {
        LOG.info("Mavenizing ProjectModel " + projectModel.toPrettyString());
        MavenizationContext mavCtx = new MavenizationContext();
        mavCtx.graphContext = this.grCtx;
        WindupConfigurationModel config = (WindupConfigurationModel)this.grCtx.getUnique(WindupConfigurationModel.class);
        mavCtx.mavenizedBaseDir = config.getOutputPath().asFile().toPath().resolve(OUTPUT_SUBDIR_MAVENIZED);
        mavCtx.unifiedGroupId = new ModuleAnalysisHelper(this.grCtx).deriveGroupId(projectModel);
        mavCtx.unifiedAppName = MavenizationService.normalizeDirName(projectModel.getName());
        mavCtx.unifiedVersion = "1.0";
        mavCtx.rootPom = new Pom(new MavenCoord(mavCtx.getUnifiedGroupId(), mavCtx.getUnifiedAppName() + "-parent", mavCtx.getUnifiedVersion()));
        ((MavenizationContext)mavCtx).rootPom.role = Pom.ModuleRole.PARENT;
        ((MavenizationContext)mavCtx).rootPom.name = projectModel.getName() + " - Parent";
        ((MavenizationContext)mavCtx).rootPom.description = "Parent of " + projectModel.getName();
        ((MavenizationContext)mavCtx).rootPom.root = true;
        String bomArtifactId = mavCtx.getUnifiedAppName() + "-bom";
        Pom bom = new Pom(new MavenCoord(mavCtx.getUnifiedGroupId(), bomArtifactId, mavCtx.getUnifiedVersion()));
        bom.bom = this.getTargetTechnologies().contains("eap7") ? MavenizeRuleProvider.JBOSS_BOM_JAVAEE7_WITH_ALL : MavenizeRuleProvider.JBOSS_BOM_JAVAEE6_WITH_ALL;
        bom.role = Pom.ModuleRole.BOM;
        bom.parent = new Pom(MavenizeRuleProvider.JBOSS_PARENT);
        bom.description = "Bill of Materials. See https://maven.apache.org/guides/introduction/introduction-to-dependency-mechanism.html";
        bom.name = projectModel.getName() + " - BOM";
        mavCtx.getRootPom().submodules.put((Object)bomArtifactId, (Object)bom);
        mavCtx.bom = bom;
        for (ArchiveCoordinateModel dep : ((GlobalBomModel)this.grCtx.getUnique(GlobalBomModel.class)).getDependencies()) {
            LOG.info("Adding dep to BOM: " + dep.toPrettyString());
            bom.dependencies.add(new SimpleDependency(Dependency.Role.LIBRARY, MavenCoord.from(dep)));
        }
        mavCtx.rootAppPom = this.mavenizeModule(mavCtx, projectModel, null);
        new MavenStructureRenderer(mavCtx).createMavenProjectDirectoryTree();
    }

    private Pom mavenizeModule(MavenizationContext mavCtx, ProjectModel projectModel, Pom containingModule) {
        LOG.info("Mavenizing submodule ProjectModel " + projectModel.toPrettyString());
        LOG.info("    Root file: " + projectModel.getRootFileModel().toPrettyString());
        LOG.info("    Containing module: " + containingModule);
        if (projectModel.getRootFileModel().getParseError() != null) {
            return null;
        }
        if (projectModel.getRootFileModel() instanceof IdentifiedArchiveModel) {
            IdentifiedArchiveModel idArch = (IdentifiedArchiveModel)projectModel.getRootFileModel();
            if (idArch == null) {
                LOG.warning("Project's IdentifiedArchiveModel getRootFileModel() returned null.");
            } else if (idArch.getCoordinate() == null) {
                LOG.warning("Project's IdentifiedArchiveModel getRootFileModel().getCoordinate() returned null.");
            } else if (containingModule == null) {
                LOG.warning("containingModule is null.");
            } else {
                containingModule.dependencies.add(new SimpleDependency(Dependency.Role.LIBRARY, MavenCoord.from(idArch.getCoordinate())));
            }
            LOG.info("Known library, skipping recursive mavenization: " + idArch.getCoordinate());
            return null;
        }
        if (projectModel.getRootFileModel() instanceof ArchiveModel) {
            HashSet<String> skipOrganizations = new HashSet<String>(Arrays.asList("Apache Sun Iona IBM Codehaus Spring Sonatype JBoss Oracle".toLowerCase().split("")));
            ArchiveModel arch = (ArchiveModel)projectModel.getRootFileModel();
            for (OrganizationModel org : arch.getOrganizationModels()) {
                if (!skipOrganizations.contains(org.getName().toLowerCase())) continue;
                LOG.info("Library from 3rd party vendor (" + org.getName() + "), skipping recursive mavenization: " + arch.getFilePath());
                return null;
            }
        }
        MavenCoord modulePomCoords = new MavenCoord();
        modulePomCoords.setGroupId(mavCtx.getUnifiedGroupId());
        modulePomCoords.setVersion(mavCtx.getUnifiedVersion());
        String artifactId = this.deriveAppropriateArtifactId(projectModel);
        modulePomCoords.setArtifactId(artifactId);
        modulePomCoords.setPackaging(MavenizationService.guessPackaging(projectModel));
        Pom modulePom = new Pom(modulePomCoords);
        modulePom.role = Pom.ModuleRole.NORMAL;
        modulePom.parent = mavCtx.getRootPom();
        mavCtx.getRootPom().submodules.put((Object)artifactId, (Object)modulePom);
        mavCtx.getKnownSubmodules().add(modulePom);
        if (containingModule != null) {
            containingModule.dependencies.add(modulePom);
        }
        HashSet<ArchiveModel> nestedModules = new HashSet<ArchiveModel>();
        for (FileModel file : projectModel.getFileModelsNoDirectories()) {
            if (!(file instanceof ArchiveModel)) continue;
            if (file instanceof IdentifiedArchiveModel) {
                IdentifiedArchiveModel artifact = (IdentifiedArchiveModel)file;
                modulePom.dependencies.add(new SimpleDependency(Dependency.Role.LIBRARY, MavenCoord.from(artifact.getCoordinate())));
                continue;
            }
            nestedModules.add((ArchiveModel)file);
        }
        for (ProjectModel subProject : projectModel.getChildProjects()) {
            Pom subModulePom = this.mavenizeModule(mavCtx, subProject, modulePom);
            if (subModulePom == null) continue;
            modulePom.dependencies.add(subModulePom);
        }
        for (ArchiveModel archiveModel : nestedModules) {
        }
        new FeatureBasedApiDependenciesDeducer(mavCtx).addAppropriateDependencies(projectModel, modulePom);
        return modulePom;
    }

    private static String normalizeDirName(String name) {
        if (name == null) {
            return null;
        }
        return name.toLowerCase().replaceAll("[^a-zA-Z0-9]", "-");
    }

    private static String guessPackaging(ProjectModel projectModel) {
        String projectType = projectModel.getProjectType();
        if (projectType != null) {
            return projectType;
        }
        LOG.warning("WINDUP-983 getProjectType() returned null for: " + projectModel.getRootFileModel().getPrettyPath());
        String suffix = StringUtils.substringAfterLast((String)projectModel.getRootFileModel().getFileName(), (String)".");
        if ("jar war ear sar har ".contains(suffix + " ")) {
            projectModel.setProjectType(suffix);
            return suffix;
        }
        return "unknown";
    }

    String deriveAppropriateArtifactId(ProjectModel projectModel) {
        String resultName = null;
        String name = projectModel.getName();
        if (name != null && name.length() <= 40 && !name.contains(" ")) {
            resultName = name;
        }
        if (resultName == null) {
            resultName = projectModel.getRootFileModel().getFileName();
        }
        resultName = this.removeVersion(resultName);
        if ((resultName = MavenizationService.normalizeDirName(resultName)) == null) {
            resultName = "unknownName-" + RandomStringUtils.randomAlphanumeric((int)4);
        }
        if (resultName.length() > 40) {
            resultName = resultName.substring(0, 40) + "-" + RandomStringUtils.randomAlphanumeric((int)4);
        }
        return resultName;
    }

    String removeVersion(String resultName) {
        if (resultName == null) {
            return null;
        }
        return resultName.replaceFirst("[-_]\\d+(\\.\\d+)+(-SNAPSHOT|[.-_](?i:CR|RC|GA|Alpha|Beta|b|milestone|m|Final|RELEASE)[.-_]?\\d+|-incubating)?(?=[-_.]\\w+)", "");
    }

    private OrderedMap<String, Pom> sortSubmodulesToReflectDependencies(Pom pom) {
        HashSet<MavenCoord> dependenciesMet = new HashSet<MavenCoord>();
        dependenciesMet.add(pom.coord);
        TreeSet dependenciesSatisfied = new TreeSet();
        for (Dependency dependency : pom.dependencies) {
        }
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    private Set<String> getTargetTechnologies() {
        WindupConfigurationModel wc = (WindupConfigurationModel)this.grCtx.getUnique(WindupConfigurationModel.class);
        Iterable targetTechnologies = wc.getTargetTechnologies();
        HashSet<String> techs = new HashSet<String>();
        for (TechnologyReferenceModel tech : targetTechnologies) {
            techs.add(tech.getTechnologyID());
        }
        return techs;
    }

    static class MavenizationContext {
        private Path mavenizedBaseDir;
        private Pom rootPom;
        private Set<Pom> knownSubmodules = new HashSet<Pom>();
        private String unifiedVersion;
        private String unifiedGroupId;
        private String unifiedAppName;
        private Pom bom;
        private GraphContext graphContext;
        private Pom rootAppPom;

        MavenizationContext() {
        }

        public Path getMavenizedBaseDir() {
            return this.mavenizedBaseDir;
        }

        public Pom getRootPom() {
            return this.rootPom;
        }

        public Set<Pom> getKnownSubmodules() {
            return this.knownSubmodules;
        }

        public String getUnifiedVersion() {
            return this.unifiedVersion;
        }

        public String getUnifiedGroupId() {
            return this.unifiedGroupId;
        }

        public String getUnifiedAppName() {
            return this.unifiedAppName;
        }

        public Pom getBom() {
            return this.bom;
        }

        public GraphContext getGraphContext() {
            return this.graphContext;
        }

        public Pom getRootAppPom() {
            return this.rootAppPom;
        }

        public void setRootAppPom(Pom rootAppPom) {
            this.rootAppPom = rootAppPom;
        }
    }
}

