/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.event;

import com.tinkerpop.blueprints.IndexableGraph;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.util.wrappers.WrapperGraph;
import com.tinkerpop.blueprints.util.wrappers.event.EventIndexableGraph;
import com.tinkerpop.blueprints.util.wrappers.event.EventTrigger;

public class EventTransactionalIndexableGraph<T extends IndexableGraph & TransactionalGraph>
extends EventIndexableGraph<T>
implements TransactionalGraph,
IndexableGraph,
WrapperGraph<T> {
    public EventTransactionalIndexableGraph(T baseIndexableGraph) {
        super(baseIndexableGraph);
        this.trigger = new EventTrigger(this, true);
    }

    @Override
    public void stopTransaction(TransactionalGraph.Conclusion conclusion) {
        if (TransactionalGraph.Conclusion.SUCCESS == conclusion) {
            this.commit();
        } else {
            this.rollback();
        }
    }

    @Override
    public void commit() {
        boolean transactionFailure = false;
        try {
            ((TransactionalGraph)((Object)((IndexableGraph)this.baseGraph))).commit();
        }
        catch (RuntimeException re) {
            transactionFailure = true;
            throw re;
        }
        finally {
            if (!transactionFailure) {
                this.trigger.fireEventQueue();
                this.trigger.resetEventQueue();
            }
        }
    }

    @Override
    public void rollback() {
        boolean transactionFailure = false;
        try {
            ((TransactionalGraph)((Object)((IndexableGraph)this.baseGraph))).rollback();
        }
        catch (RuntimeException re) {
            transactionFailure = true;
            throw re;
        }
        finally {
            if (!transactionFailure) {
                this.trigger.resetEventQueue();
            }
        }
    }
}

