/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config;

import org.jboss.forge.furnace.proxy.Proxies;
import org.jboss.forge.furnace.util.Annotations;
import org.jboss.windup.config.RuleProvider;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.metadata.RuleMetadataType;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.Context;
import org.ocpsoft.rewrite.context.ContextBase;

public abstract class AbstractRuleProvider
extends ContextBase
implements RuleProvider {
    private int executionIndex;
    private RuleProviderMetadata metadata;

    public AbstractRuleProvider() {
        if (Proxies.isForgeProxy((Object)this) && !Annotations.isAnnotationPresent(this.getClass(), RuleMetadata.class)) {
            return;
        }
        if (!Annotations.isAnnotationPresent(this.getClass(), RuleMetadata.class)) {
            throw new IllegalStateException(this.getClass().getName() + " must either be abstract, or specify @" + RuleMetadata.class.getName() + ", or call a super() constructor and provide " + RuleProviderMetadata.class.getName());
        }
        this.metadata = MetadataBuilder.forProvider(this.getClass());
    }

    public AbstractRuleProvider(RuleProviderMetadata metadata) {
        this.metadata = metadata;
    }

    public AbstractRuleProvider(Class<? extends RuleProvider> implementationType, String id) {
        this.metadata = MetadataBuilder.forProvider(implementationType, id);
    }

    @Override
    public RuleProviderMetadata getMetadata() {
        return this.metadata;
    }

    public boolean handles(Object payload) {
        return payload instanceof RuleLoaderContext;
    }

    public static void enhanceRuleMetadata(RuleProvider provider, Rule rule) {
        if (rule instanceof Context) {
            Context context = (Context)rule;
            if (!context.containsKey((Object)RuleMetadataType.ORIGIN)) {
                context.put((Object)RuleMetadataType.ORIGIN, (Object)provider.getMetadata().getOrigin());
            }
            if (!context.containsKey((Object)RuleMetadataType.RULE_PROVIDER)) {
                context.put((Object)RuleMetadataType.RULE_PROVIDER, (Object)provider);
            }
            if (!context.containsKey((Object)RuleMetadataType.TAGS)) {
                context.put((Object)RuleMetadataType.TAGS, provider.getMetadata().getTags());
            }
        }
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other instanceof AbstractRuleProvider) {
            AbstractRuleProvider that = (AbstractRuleProvider)other;
            result = this.getMetadata().equals(that.getMetadata());
        }
        return result;
    }

    public int hashCode() {
        return this.getMetadata().hashCode();
    }

    public final int getExecutionIndex() {
        return this.executionIndex;
    }

    public final void setExecutionIndex(int executionIndex) {
        this.executionIndex = executionIndex;
    }

    public final int priority() {
        return 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.metadata.getID());
        if (!this.metadata.getID().equals(this.metadata.getOrigin())) {
            builder.append(" from ").append(this.metadata.getOrigin());
        }
        return builder.toString();
    }
}

