/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.batch.cache;

import com.tinkerpop.blueprints.util.wrappers.batch.cache.StringCompression;
import java.util.HashMap;
import java.util.Map;

public class URLCompression
implements StringCompression {
    private static final String DELIMITER = "$";
    private int prefixCounter = 0;
    private final Map<String, String> urlPrefix = new HashMap<String, String>();
    private static final char[] urlDelimiters = new char[]{'/', '#', ':'};

    @Override
    public String compress(String input) {
        String[] url = URLCompression.splitURL(input);
        String prefix = this.urlPrefix.get(url[0]);
        if (prefix == null) {
            prefix = Long.toString(this.prefixCounter, 36) + DELIMITER;
            ++this.prefixCounter;
            this.urlPrefix.put(url[0], prefix);
        }
        return prefix + url[1];
    }

    private static final String[] splitURL(String url) {
        String[] res = new String[2];
        int pos = -1;
        for (char delimiter : urlDelimiters) {
            int currentpos = url.lastIndexOf(delimiter);
            if (currentpos <= pos) continue;
            pos = currentpos;
        }
        if (pos < 0) {
            res[0] = "";
            res[1] = url;
        } else {
            res[0] = url.substring(0, pos + 1);
            res[1] = url.substring(pos + 1);
        }
        return res;
    }
}

