/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules;

import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.ast.java.data.TypeReferenceLocation;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.Iteration;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.rules.apps.java.condition.JavaClass;
import org.jboss.windup.rules.apps.java.model.AbstractJavaSourceModel;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.scan.ast.JavaTypeReferenceModel;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationLiteralTypeValueModel;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationTypeReferenceModel;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationTypeValueModel;
import org.jboss.windup.rules.apps.java.scan.provider.AnalyzeJavaFilesRuleProvider;
import org.jboss.windup.rules.apps.java.service.JavaClassService;
import org.jboss.windup.rules.apps.javaee.service.JaxWSWebServiceModelService;
import org.jboss.windup.util.Logging;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=InitialAnalysisPhase.class, after={AnalyzeJavaFilesRuleProvider.class})
public class DiscoverJaxWSAnnotationsRuleProvider
extends AbstractRuleProvider {
    private static final Logger LOG = Logging.get(DiscoverJaxWSAnnotationsRuleProvider.class);
    private static final String JAXWS_ANNOTATIONS = "jaxwsAnnotations";

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        String ruleIDPrefix = ((Object)((Object)this)).getClass().getSimpleName();
        return ConfigurationBuilder.begin().addRule().when((Condition)JavaClass.references((String)"javax.jws.WebService").at(new TypeReferenceLocation[]{TypeReferenceLocation.ANNOTATION}).as(JAXWS_ANNOTATIONS)).perform((Operation)Iteration.over((String)JAXWS_ANNOTATIONS).perform((Operation)new AbstractIterationOperation<JavaTypeReferenceModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, JavaTypeReferenceModel payload) {
                DiscoverJaxWSAnnotationsRuleProvider.this.extractMetadata(event, payload);
            }
        }).endIteration()).withId(ruleIDPrefix + "_JAXWSAnnotationRule");
    }

    private void extractMetadata(GraphRewrite event, JavaTypeReferenceModel typeReference) {
        JavaClassService javaClassService = new JavaClassService(event.getGraphContext());
        JavaClassModel implementationClass = this.getJavaClass(typeReference);
        if (!implementationClass.getInterfaces().iterator().hasNext()) {
            return;
        }
        LOG.info("Processing: " + typeReference);
        typeReference.getFile().setGenerateSourceReport(true);
        JavaAnnotationTypeReferenceModel jaxWsAnnotationTypeReference = (JavaAnnotationTypeReferenceModel)typeReference;
        String endpointInterfaceQualifiedName = this.getAnnotationLiteralValue(jaxWsAnnotationTypeReference, "endpointInterface");
        JavaClassModel endpointInterface = null;
        if (StringUtils.isNotBlank((CharSequence)endpointInterfaceQualifiedName)) {
            endpointInterface = javaClassService.getOrCreatePhantom(endpointInterfaceQualifiedName);
            for (AbstractJavaSourceModel source : javaClassService.getJavaSource(endpointInterface.getQualifiedName())) {
                source.setGenerateSourceReport(true);
            }
        }
        JaxWSWebServiceModelService service = new JaxWSWebServiceModelService(event.getGraphContext());
        service.getOrCreate(typeReference.getFile().getApplication(), endpointInterface, implementationClass);
    }

    private JavaClassModel getJavaClass(JavaTypeReferenceModel javaTypeReference) {
        JavaClassModel result = null;
        AbstractJavaSourceModel javaSource = javaTypeReference.getFile();
        for (JavaClassModel javaClassModel : javaSource.getJavaClasses()) {
            if (javaClassModel.isPublic() == null || !javaClassModel.isPublic().booleanValue()) continue;
            result = javaClassModel;
            break;
        }
        if (result == null) {
            result = (JavaClassModel)javaSource.getJavaClasses().iterator().next();
        }
        return result;
    }

    private String getAnnotationLiteralValue(JavaAnnotationTypeReferenceModel model, String name) {
        JavaAnnotationTypeValueModel valueModel = (JavaAnnotationTypeValueModel)model.getAnnotationValues().get(name);
        if (valueModel instanceof JavaAnnotationLiteralTypeValueModel) {
            JavaAnnotationLiteralTypeValueModel literalTypeValue = (JavaAnnotationLiteralTypeValueModel)valueModel;
            return literalTypeValue.getLiteralValue();
        }
        return null;
    }

    public String toString() {
        return "DiscoverEJBAnnotatedClasses";
    }
}

