/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules.jboss;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.MigrationRulesPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.LinkModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.LinkService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.model.WindupVertexListModel;
import org.jboss.windup.reporting.service.ApplicationReportService;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.rules.apps.javaee.model.EjbDeploymentDescriptorModel;
import org.jboss.windup.rules.apps.javaee.model.EjbMessageDrivenModel;
import org.jboss.windup.rules.apps.javaee.model.EjbSessionBeanModel;
import org.jboss.windup.rules.apps.javaee.model.association.VendorSpecificationExtensionModel;
import org.jboss.windup.rules.apps.javaee.service.VendorSpecificationExtensionService;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=MigrationRulesPhase.class, id="Generate jboss-ejb3.xml")
public class GenerateJBossEjbDescriptorRuleProvider
extends AbstractRuleProvider {
    private static final Logger LOG = Logger.getLogger(GenerateJBossEjbDescriptorRuleProvider.class.getSimpleName());
    public static final String TEMPLATE_EJB_REPORT = "/reports/templates/jboss/jboss-ejb3.ftl";

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().when((Condition)Query.fromType(EjbDeploymentDescriptorModel.class)).perform((Operation)new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                WindupConfigurationModel configurationModel = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
                for (FileModel inputPath : configurationModel.getInputPaths()) {
                    ProjectModel application = inputPath.getProjectModel();
                    GenerateJBossEjbDescriptorRuleProvider.this.createReport(event, context, event.getGraphContext(), application);
                }
            }

            public String toString() {
                return "Generate jboss-ejb3.xml";
            }
        });
    }

    private void createReport(GraphRewrite event, EvaluationContext evaluationContext, GraphContext context, ProjectModel projectModel) {
        ClassificationService classificationService = new ClassificationService(context);
        VendorSpecificationExtensionService vendorSpecificService = new VendorSpecificationExtensionService(context);
        LinkService linkService = new LinkService(context);
        for (EjbDeploymentDescriptorModel ejbDescriptor : this.findAllEjbDescsInProject(context, projectModel)) {
            ApplicationReportService applicationReportService = new ApplicationReportService(context);
            ApplicationReportModel applicationReportModel = applicationReportService.create();
            applicationReportModel.setReportPriority(300);
            applicationReportModel.setDisplayInApplicationReportIndex(Boolean.valueOf(false));
            applicationReportModel.setReportName("jboss-ejb3.xml");
            applicationReportModel.setProjectModel(projectModel);
            applicationReportModel.setTemplatePath(TEMPLATE_EJB_REPORT);
            applicationReportModel.setTemplateType(TemplateType.FREEMARKER);
            GraphService listService = new GraphService(context, WindupVertexListModel.class);
            WindupVertexListModel sessionBeans = (WindupVertexListModel)listService.create();
            for (EjbSessionBeanModel ejbSessionBeanModel : ejbDescriptor.getEjbSessionBeans()) {
                sessionBeans.addItem((WindupVertexFrame)ejbSessionBeanModel);
            }
            WindupVertexListModel messageDrivenBeans = (WindupVertexListModel)listService.create();
            for (EjbMessageDrivenModel mb : ejbDescriptor.getMessageDriven()) {
                messageDrivenBeans.addItem((WindupVertexFrame)mb);
            }
            HashMap<String, WindupVertexListModel> hashMap = new HashMap<String, WindupVertexListModel>(4);
            hashMap.put("sessionBeans", sessionBeans);
            hashMap.put("messageDriven", messageDrivenBeans);
            applicationReportModel.setRelatedResource(hashMap);
            ReportService reportService = new ReportService(context);
            reportService.setUniqueFilename((ReportModel)applicationReportModel, "jboss-ejb3_" + projectModel.getName(), "xml");
            LOG.info("Generated jboss-ejb3.xml for " + ejbDescriptor.getFilePath() + " at: " + applicationReportModel.getReportFilename());
            LinkModel newDescriptorLink = (LinkModel)linkService.create();
            newDescriptorLink.setDescription("JBoss EJB XML Descriptor - Generated by Red Hat Application Migration Toolkit");
            newDescriptorLink.setLink(applicationReportModel.getReportFilename());
            for (VendorSpecificationExtensionModel vendorSpecificExtension : vendorSpecificService.getVendorSpecificationExtensions((FileModel)ejbDescriptor)) {
                LOG.info("Vendor specific: " + vendorSpecificExtension.getFileName());
                classificationService.attachClassification(event, evaluationContext, (FileModel)vendorSpecificExtension, "EJB Specification Extension", "Vendor Specific EJB Specification Extension");
                vendorSpecificExtension.addLinkToTransformedFile(newDescriptorLink);
            }
            ejbDescriptor.addLinkToTransformedFile(newDescriptorLink);
        }
    }

    private Iterable<EjbDeploymentDescriptorModel> findAllEjbDescsInProject(GraphContext context, ProjectModel application) {
        GraphService ejbDescriptorService = new GraphService(context, EjbDeploymentDescriptorModel.class);
        ArrayList<EjbDeploymentDescriptorModel> resultModels = new ArrayList<EjbDeploymentDescriptorModel>();
        for (EjbDeploymentDescriptorModel ejbDesc : ejbDescriptorService.findAll()) {
            if (!ejbDesc.getProjectModel().getRootProjectModel().equals(application)) continue;
            resultModels.add(ejbDesc);
        }
        return resultModels;
    }
}

