/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph;

import com.tinkerpop.blueprints.Element;
import com.tinkerpop.frames.FrameInitializer;
import com.tinkerpop.frames.FramedGraph;
import com.tinkerpop.frames.Property;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.jboss.windup.graph.frames.FrameBooleanDefaultValue;

public class DefaultValueInitializer
implements FrameInitializer {
    private Map<Class<?>, LinkedList<PropertyDefaultValue>> cachedValues = new HashMap();

    public void initElement(Class<?> kind, FramedGraph<?> framedGraph, Element element) {
        if (!this.cachedValues.containsKey(kind)) {
            this.cacheFrameInterface(kind);
        }
        this.setupDefaults(element, this.cachedValues.get(kind));
    }

    private void cacheFrameInterface(Class<?> kind) {
        LinkedList<PropertyDefaultValue> values = new LinkedList<PropertyDefaultValue>();
        for (Method m : kind.getMethods()) {
            Annotation[] annotations = m.getAnnotations();
            for (Annotation annotation : m.getAnnotations()) {
                if (!(annotation instanceof FrameBooleanDefaultValue)) continue;
                PropertyDefaultValue pDefault = new PropertyDefaultValue();
                pDefault.value = ((FrameBooleanDefaultValue)annotation).value();
                pDefault.key = m.getAnnotation(Property.class).value();
                values.add(pDefault);
            }
        }
        this.cachedValues.put(kind, values);
    }

    private void setupDefaults(Element element, LinkedList<PropertyDefaultValue> values) {
        for (PropertyDefaultValue pValue : values) {
            element.setProperty(pValue.key, pValue.value);
        }
    }

    private class PropertyDefaultValue {
        private String key;
        private Object value;

        private PropertyDefaultValue() {
        }
    }
}

