/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.xml.service;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.rules.apps.xml.model.XsltTransformationModel;
import org.jboss.windup.util.exception.WindupException;

public class XsltTransformationService
extends GraphService<XsltTransformationModel> {
    public static final String TRANSFORMEDXML_DIR_NAME = "transformedxml";

    public XsltTransformationService(GraphContext ctx) {
        super(ctx, XsltTransformationModel.class);
    }

    public Path getTransformedXSLTPath() {
        ReportService reportService = new ReportService(this.getGraphContext());
        Path outputPath = reportService.getReportDirectory().resolve(TRANSFORMEDXML_DIR_NAME);
        if (!Files.isDirectory(outputPath, new LinkOption[0])) {
            try {
                Files.createDirectories(outputPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new WindupException("Failed to create output directory at: " + outputPath + " due to: " + e.getMessage(), (Throwable)e);
            }
        }
        return outputPath;
    }
}

