/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.condition.annotation;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.condition.EvaluationStrategy;
import org.jboss.windup.rules.apps.java.condition.annotation.AnnotationCondition;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationListTypeValueModel;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationTypeValueModel;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class AnnotationListCondition
extends AnnotationCondition {
    private static final int ANY = -1;
    private final int index;
    private List<AnnotationCondition> conditions = new ArrayList<AnnotationCondition>();

    public AnnotationListCondition() {
        this(-1);
    }

    public AnnotationListCondition(int index) {
        this.index = index;
    }

    public AnnotationListCondition addCondition(AnnotationCondition condition) {
        this.conditions.add(condition);
        return this;
    }

    public String toString() {
        return "AnnotationListCondition{index=" + this.index + ", conditions=" + this.conditions + '}';
    }

    @Override
    public boolean evaluate(GraphRewrite event, EvaluationContext context, EvaluationStrategy strategy, JavaAnnotationTypeValueModel value) {
        if (!(value instanceof JavaAnnotationListTypeValueModel)) {
            return false;
        }
        JavaAnnotationListTypeValueModel listTypeValueModel = (JavaAnnotationListTypeValueModel)value;
        List<JavaAnnotationTypeValueModel> selectedValues = this.getSelectedValues(listTypeValueModel);
        if (selectedValues == null) {
            return false;
        }
        boolean matched = false;
        for (AnnotationCondition condition : this.conditions) {
            Iterator iterator = listTypeValueModel.iterator();
            while (iterator.hasNext()) {
                JavaAnnotationTypeValueModel subValue = (JavaAnnotationTypeValueModel)iterator.next();
                if (!condition.evaluate(event, context, strategy, subValue)) continue;
                matched = true;
                break;
            }
            if (!matched) continue;
            break;
        }
        return matched;
    }

    private List<JavaAnnotationTypeValueModel> getSelectedValues(JavaAnnotationListTypeValueModel listTypeValueModel) {
        ArrayList<JavaAnnotationTypeValueModel> selectedValues = new ArrayList<JavaAnnotationTypeValueModel>();
        if (this.index == -1) {
            Iterator iterator = listTypeValueModel.iterator();
            while (iterator.hasNext()) {
                JavaAnnotationTypeValueModel listItem = (JavaAnnotationTypeValueModel)iterator.next();
                selectedValues.add(listItem);
            }
        } else {
            try {
                selectedValues.add((JavaAnnotationTypeValueModel)Iterables.get((Iterable)((Object)listTypeValueModel), (int)this.index));
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        return selectedValues;
    }
}

