/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.resource.monitor;

import java.io.IOException;
import java.lang.annotation.Annotation;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.ResourceFilter;
import org.jboss.forge.addon.resource.monitor.FileWatcher;
import org.jboss.forge.addon.resource.monitor.ResourceMonitor;
import org.jboss.forge.addon.resource.monitor.ResourceMonitorImpl;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.container.simple.EventListener;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.event.PreShutdown;

public class FileMonitor
implements EventListener {
    private FileWatcher watcher;

    void init() throws Exception {
        this.watcher = new FileWatcher();
        this.watcher.start();
    }

    void destroy() {
        if (this.watcher != null) {
            this.watcher.stop();
            this.watcher = null;
        }
    }

    public synchronized void handleEvent(Object event, Annotation ... qualifiers) {
        Addon addon;
        if (event instanceof PreShutdown && (addon = SimpleContainer.getAddon((ClassLoader)this.getClass().getClassLoader())).equals(((PreShutdown)event).getAddon())) {
            this.destroy();
        }
    }

    public ResourceMonitor registerMonitor(ResourceFactory resourceFactory, final FileResource<?> resource, final ResourceFilter resourceFilter) {
        if (this.watcher == null) {
            try {
                this.init();
            }
            catch (Exception e) {
                throw new IllegalStateException("Error while initializing FileMonitor", e);
            }
        }
        DirectoryResource dirResource = (DirectoryResource)resource.reify(DirectoryResource.class);
        ResourceFilter filter = resourceFilter;
        if (dirResource == null) {
            dirResource = resource.getParent();
            filter = new ResourceFilter(){

                public boolean accept(Resource<?> type) {
                    boolean isMonitoredFile = type.equals((Object)resource);
                    if (!isMonitoredFile) {
                        return false;
                    }
                    if (resourceFilter != null) {
                        return resourceFilter.accept(type);
                    }
                    return true;
                }
            };
        }
        ResourceMonitorImpl resourceMonitor = new ResourceMonitorImpl(this, dirResource, resourceFactory, filter);
        try {
            this.watcher.register(resourceMonitor);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not register resource monitor", e);
        }
        return resourceMonitor;
    }

    void cancel(ResourceMonitorImpl monitor) {
        this.watcher.unregister(monitor);
    }
}

