/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.jboss.forge.roaster.ParserException;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.compiler.IProblem;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTNode;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ImportDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Javadoc;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Modifier;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.PackageDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jface.text.Document;
import org.jboss.forge.roaster._shade.org.eclipse.text.edits.TextEdit;
import org.jboss.forge.roaster.model.Annotation;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.SyntaxError;
import org.jboss.forge.roaster.model.Visibility;
import org.jboss.forge.roaster.model.VisibilityScoped;
import org.jboss.forge.roaster.model.ast.AnnotationAccessor;
import org.jboss.forge.roaster.model.ast.ModifierAccessor;
import org.jboss.forge.roaster.model.impl.ImportImpl;
import org.jboss.forge.roaster.model.impl.JavaDocImpl;
import org.jboss.forge.roaster.model.impl.SyntaxErrorImpl;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.AnnotationTargetSource;
import org.jboss.forge.roaster.model.source.Import;
import org.jboss.forge.roaster.model.source.JavaDocSource;
import org.jboss.forge.roaster.model.source.JavaPackageInfoSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.VisibilityScopedSource;
import org.jboss.forge.roaster.model.util.Formatter;
import org.jboss.forge.roaster.model.util.Strings;
import org.jboss.forge.roaster.model.util.Types;
import org.jboss.forge.roaster.spi.WildcardImportResolver;

public class JavaPackageInfoImpl
implements JavaPackageInfoSource {
    protected final Document document;
    protected final CompilationUnit unit;
    protected final PackageDeclaration pkg;
    protected final JavaSource<?> enclosingType;
    private final AnnotationAccessor<JavaPackageInfoSource, JavaPackageInfoSource> annotations = new AnnotationAccessor();
    private final ModifierAccessor modifiers = new ModifierAccessor();
    private static List<WildcardImportResolver> resolvers;

    public JavaPackageInfoImpl(JavaSource<?> enclosingType, Document document, CompilationUnit unit, PackageDeclaration pkg) {
        this.enclosingType = enclosingType == null ? this : enclosingType;
        this.document = document;
        this.unit = unit;
        this.pkg = pkg;
    }

    public String getName() {
        return "package-info";
    }

    public JavaSource<?> getEnclosingType() {
        return this.enclosingType;
    }

    public AnnotationSource<JavaPackageInfoSource> addAnnotation() {
        return this.annotations.addAnnotation((AnnotationTargetSource<JavaPackageInfoSource, JavaPackageInfoSource>)this, this.getPackageDeclaration());
    }

    public AnnotationSource<JavaPackageInfoSource> addAnnotation(Class<? extends java.lang.annotation.Annotation> clazz) {
        return this.annotations.addAnnotation((AnnotationTargetSource<JavaPackageInfoSource, JavaPackageInfoSource>)this, (ASTNode)this.getPackageDeclaration(), clazz.getName());
    }

    public AnnotationSource<JavaPackageInfoSource> addAnnotation(String className) {
        return this.annotations.addAnnotation((AnnotationTargetSource<JavaPackageInfoSource, JavaPackageInfoSource>)this, (ASTNode)this.getPackageDeclaration(), className);
    }

    public List<AnnotationSource<JavaPackageInfoSource>> getAnnotations() {
        return this.annotations.getAnnotations((AnnotationTargetSource<JavaPackageInfoSource, JavaPackageInfoSource>)this, this.getPackageDeclaration());
    }

    public boolean hasAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.hasAnnotation(this, this.getPackageDeclaration(), type.getName());
    }

    public boolean hasAnnotation(String type) {
        return this.annotations.hasAnnotation(this, this.getPackageDeclaration(), type);
    }

    public JavaPackageInfoSource removeAnnotation(Annotation<JavaPackageInfoSource> annotation) {
        return this.annotations.removeAnnotation(this, this.getPackageDeclaration(), annotation);
    }

    public AnnotationSource<JavaPackageInfoSource> getAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.getAnnotation((AnnotationTargetSource<JavaPackageInfoSource, JavaPackageInfoSource>)this, (ASTNode)this.getPackageDeclaration(), type);
    }

    public AnnotationSource<JavaPackageInfoSource> getAnnotation(String type) {
        return this.annotations.getAnnotation((AnnotationTargetSource<JavaPackageInfoSource, JavaPackageInfoSource>)this, (ASTNode)this.getPackageDeclaration(), type);
    }

    public Import addImport(Class<?> type) {
        return this.addImport(type.getCanonicalName());
    }

    public <T extends JavaType<?>> Import addImport(T type) {
        String qualifiedName = type.getQualifiedName();
        return this.addImport(qualifiedName);
    }

    public Import addImport(Import imprt) {
        return this.addImport(imprt.getQualifiedName()).setStatic(imprt.isStatic());
    }

    public Import addImport(String className) {
        Import imprt;
        String strippedClassName = Types.stripGenerics((String)Types.stripArray((String)className));
        if (Types.isSimpleName((String)strippedClassName) && !this.hasImport(strippedClassName)) {
            throw new IllegalArgumentException("Cannot import class without a package [" + strippedClassName + "]");
        }
        if (!this.hasImport(strippedClassName) && this.validImport(strippedClassName)) {
            imprt = new ImportImpl((JavaSource<?>)this).setName(strippedClassName);
            this.unit.imports().add(imprt.getInternal());
        } else if (this.hasImport(strippedClassName)) {
            imprt = this.getImport(strippedClassName);
        } else {
            throw new IllegalArgumentException("Attempted to import the illegal type [" + strippedClassName + "]");
        }
        return imprt;
    }

    public Import getImport(String className) {
        List<Import> imports = this.getImports();
        for (Import imprt : imports) {
            if (!imprt.getQualifiedName().equals(className) && !imprt.getSimpleName().equals(className)) continue;
            return imprt;
        }
        return null;
    }

    public Import getImport(Class<?> type) {
        return this.getImport(type.getName());
    }

    public <T extends JavaType<?>> Import getImport(T type) {
        return this.getImport(type.getQualifiedName());
    }

    public Import getImport(Import imprt) {
        return this.getImport(imprt.getQualifiedName());
    }

    public List<Import> getImports() {
        ArrayList<ImportImpl> results = new ArrayList<ImportImpl>();
        for (ImportDeclaration i : this.unit.imports()) {
            results.add(new ImportImpl((JavaSource<?>)this, i));
        }
        return Collections.unmodifiableList(results);
    }

    public boolean hasImport(Class<?> type) {
        return this.hasImport(type.getName());
    }

    public <T extends JavaType<T>> boolean hasImport(T type) {
        return this.hasImport(type.getQualifiedName());
    }

    public boolean hasImport(Import imprt) {
        return this.hasImport(imprt.getQualifiedName());
    }

    public boolean hasImport(String type) {
        String resultType = type;
        if (Types.isArray((String)type)) {
            resultType = Types.stripArray((String)type);
        }
        if (Types.isGeneric((String)type)) {
            resultType = Types.stripGenerics((String)type);
        }
        return this.getImport(resultType) != null;
    }

    public boolean requiresImport(Class<?> type) {
        return this.requiresImport(type.getName());
    }

    public boolean requiresImport(String type) {
        String resultType = type;
        if (Types.isArray((String)resultType)) {
            resultType = Types.stripArray((String)type);
        }
        if (Types.isGeneric((String)resultType)) {
            resultType = Types.stripGenerics((String)resultType);
        }
        return this.validImport(resultType) && !this.hasImport(resultType) && !Types.isJavaLang((String)resultType);
    }

    public String resolveType(String type) {
        String original = type;
        String result = type;
        if (Types.isArray((String)result)) {
            original = Types.stripArray((String)result);
            result = Types.stripArray((String)result);
        }
        if (Types.isGeneric((String)result)) {
            original = Types.stripGenerics((String)result);
            result = Types.stripGenerics((String)result);
        }
        if (Types.isPrimitive((String)result)) {
            return result;
        }
        if (Types.isSimpleName((String)result)) {
            if (!this.hasImport(type) && Types.isJavaLang((String)type)) {
                result = "java.lang." + result;
            }
            if (result.equals(original)) {
                for (Import imprt : this.getImports()) {
                    if (!Types.areEquivalent((String)result, (String)imprt.getQualifiedName())) continue;
                    result = imprt.getQualifiedName();
                    break;
                }
            }
        }
        if (Types.isSimpleName((String)result)) {
            for (Import imprt : this.getImports()) {
                WildcardImportResolver r;
                if (!imprt.isWildcard()) continue;
                Iterator<WildcardImportResolver> iterator = this.getImportResolvers().iterator();
                while (iterator.hasNext() && !Types.isQualified((String)(result = (r = iterator.next()).resolve((JavaType)this, result)))) {
                }
            }
        }
        if (Types.isSimpleName((String)result) && this.getPackage() != null) {
            result = this.getPackage() + "." + result;
        }
        return result;
    }

    private List<WildcardImportResolver> getImportResolvers() {
        if (resolvers == null) {
            resolvers = new ArrayList<WildcardImportResolver>();
            for (WildcardImportResolver r : ServiceLoader.load(WildcardImportResolver.class, this.getClass().getClassLoader())) {
                resolvers.add(r);
            }
        }
        if (resolvers.size() == 0) {
            throw new IllegalStateException("No instances of [" + WildcardImportResolver.class.getName() + "] were found on the classpath.");
        }
        return resolvers;
    }

    private boolean validImport(String type) {
        return !Strings.isNullOrEmpty((String)type) && !Types.isPrimitive((String)type);
    }

    public JavaPackageInfoSource removeImport(String name) {
        for (Import i : this.getImports()) {
            if (!i.getQualifiedName().equals(name)) continue;
            this.removeImport(i);
            break;
        }
        return this;
    }

    public JavaPackageInfoSource removeImport(Class<?> clazz) {
        return this.removeImport(clazz.getName());
    }

    public <T extends JavaType<?>> JavaPackageInfoSource removeImport(T type) {
        return this.removeImport(type.getQualifiedName());
    }

    public JavaPackageInfoSource removeImport(Import imprt) {
        Object internal = imprt.getInternal();
        if (this.unit.imports().contains(internal)) {
            this.unit.imports().remove(internal);
        }
        return this;
    }

    protected PackageDeclaration getPackageDeclaration() {
        if (this.pkg instanceof PackageDeclaration) {
            return this.pkg;
        }
        throw new ParserException("Source body was not of the expected type (PackageDeclaration).");
    }

    public JavaPackageInfoSource setName(String name) {
        throw new UnsupportedOperationException("Changing name of [" + this.getQualifiedName() + "] not supported.");
    }

    public String getCanonicalName() {
        String result = this.getName();
        for (JavaType enclosingType = this; enclosingType != enclosingType.getEnclosingType(); enclosingType = enclosingType.getEnclosingType()) {
            enclosingType = this.getEnclosingType();
            result = enclosingType.getEnclosingType().getName() + "." + result;
        }
        if (!Strings.isNullOrEmpty((String)this.getPackage())) {
            result = this.getPackage() + "." + result;
        }
        return result;
    }

    public String getQualifiedName() {
        String result = this.getName();
        for (JavaType enclosingType = this; enclosingType != enclosingType.getEnclosingType(); enclosingType = enclosingType.getEnclosingType()) {
            enclosingType = this.getEnclosingType();
            result = enclosingType.getEnclosingType().getName() + "$" + result;
        }
        if (!Strings.isNullOrEmpty((String)this.getPackage())) {
            result = this.getPackage() + "." + result;
        }
        return result;
    }

    public String getPackage() {
        PackageDeclaration pkg = this.unit.getPackage();
        if (pkg != null) {
            return pkg.getName().getFullyQualifiedName();
        }
        return null;
    }

    public JavaPackageInfoSource setPackage(String name) {
        if (this.unit.getPackage() == null) {
            this.unit.setPackage(this.unit.getAST().newPackageDeclaration());
        }
        this.unit.getPackage().setName(this.unit.getAST().newName(name));
        return this;
    }

    public JavaPackageInfoSource setDefaultPackage() {
        this.unit.setPackage(null);
        return this;
    }

    public boolean isDefaultPackage() {
        return this.unit.getPackage() == null;
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public JavaPackageInfoSource setPackagePrivate() {
        this.modifiers.clearVisibility(this.getPackageDeclaration());
        return this;
    }

    public boolean isPublic() {
        return this.modifiers.hasModifier(this.getPackageDeclaration(), Modifier.ModifierKeyword.PUBLIC_KEYWORD);
    }

    public JavaPackageInfoSource setPublic() {
        this.modifiers.clearVisibility(this.getPackageDeclaration());
        this.modifiers.addModifier(this.getPackageDeclaration(), Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        return this;
    }

    public boolean isPrivate() {
        return this.modifiers.hasModifier(this.getPackageDeclaration(), Modifier.ModifierKeyword.PRIVATE_KEYWORD);
    }

    public JavaPackageInfoSource setPrivate() {
        this.modifiers.clearVisibility(this.getPackageDeclaration());
        this.modifiers.addModifier(this.getPackageDeclaration(), Modifier.ModifierKeyword.PRIVATE_KEYWORD);
        return this;
    }

    public boolean isProtected() {
        return this.modifiers.hasModifier(this.getPackageDeclaration(), Modifier.ModifierKeyword.PROTECTED_KEYWORD);
    }

    public JavaPackageInfoSource setProtected() {
        this.modifiers.clearVisibility(this.getPackageDeclaration());
        this.modifiers.addModifier(this.getPackageDeclaration(), Modifier.ModifierKeyword.PROTECTED_KEYWORD);
        return this;
    }

    public Visibility getVisibility() {
        return Visibility.getFrom((VisibilityScoped)this);
    }

    public JavaPackageInfoSource setVisibility(Visibility scope) {
        return (JavaPackageInfoSource)Visibility.set((VisibilityScopedSource)this, (Visibility)scope);
    }

    public String toString() {
        Document document = new Document(this.document.get());
        try {
            TextEdit edit = this.unit.rewrite(document, null);
            edit.apply(document);
        }
        catch (Exception e) {
            throw new ParserException("Could not modify source: " + this.unit.toString(), (Throwable)e);
        }
        return Formatter.format(document.get());
    }

    public Object getInternal() {
        return this.unit;
    }

    public JavaPackageInfoSource getOrigin() {
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pkg == null ? 0 : this.pkg.hashCode());
        result = 31 * result + (this.document == null ? 0 : this.document.hashCode());
        result = 31 * result + (this.enclosingType == null ? 0 : this.enclosingType.hashCode());
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaPackageInfoImpl other = (JavaPackageInfoImpl)obj;
        if (this.pkg == null ? other.pkg != null : !this.pkg.equals(other.pkg)) {
            return false;
        }
        if (this.document == null ? other.document != null : !this.document.equals(other.document)) {
            return false;
        }
        if (this.enclosingType == null ? other.enclosingType != null : !this.enclosingType.equals(other.enclosingType)) {
            return false;
        }
        return !(this.unit == null ? other.unit != null : !this.unit.equals(other.unit));
    }

    public List<SyntaxError> getSyntaxErrors() {
        ArrayList<SyntaxError> result = new ArrayList<SyntaxError>();
        IProblem[] problems = this.unit.getProblems();
        if (problems != null) {
            for (IProblem problem : problems) {
                result.add(new SyntaxErrorImpl((JavaType<?>)this, problem));
            }
        }
        return result;
    }

    public boolean hasSyntaxErrors() {
        return !this.getSyntaxErrors().isEmpty();
    }

    public boolean isClass() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isAnnotation() {
        return false;
    }

    public List<JavaSource<?>> getNestedClasses() {
        return Collections.emptyList();
    }

    public JavaDocSource<JavaPackageInfoSource> getJavaDoc() {
        Javadoc javadoc = this.pkg.getJavadoc();
        if (javadoc == null) {
            javadoc = this.pkg.getAST().newJavadoc();
            this.pkg.setJavadoc(javadoc);
        }
        return new JavaDocImpl<JavaPackageInfoSource>(this, javadoc);
    }

    public JavaPackageInfoSource removeJavaDoc() {
        this.pkg.setJavadoc(null);
        return this;
    }

    public boolean hasJavaDoc() {
        return this.pkg.getJavadoc() != null;
    }
}

