/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jboss.tattletale.analyzers.Analyzer;
import org.jboss.tattletale.analyzers.ArchiveScanner;
import org.jboss.tattletale.analyzers.DirectoryScanner;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.core.Location;
import org.jboss.tattletale.core.NestableArchive;
import org.jboss.tattletale.profiles.AbstractProfile;
import org.jboss.tattletale.profiles.CDI10;
import org.jboss.tattletale.profiles.JBossAS7Profile;
import org.jboss.tattletale.profiles.JavaEE5;
import org.jboss.tattletale.profiles.JavaEE6;
import org.jboss.tattletale.profiles.Profile;
import org.jboss.tattletale.profiles.Seam22;
import org.jboss.tattletale.profiles.Spring25;
import org.jboss.tattletale.profiles.Spring30;
import org.jboss.tattletale.profiles.SunJava5;
import org.jboss.tattletale.profiles.SunJava6;
import org.jboss.tattletale.reporting.AS7Report;
import org.jboss.tattletale.reporting.BlackListedReport;
import org.jboss.tattletale.reporting.CircularDependencyReport;
import org.jboss.tattletale.reporting.ClassDependantsReport;
import org.jboss.tattletale.reporting.ClassDependsOnReport;
import org.jboss.tattletale.reporting.ClassLocationReport;
import org.jboss.tattletale.reporting.DependantsReport;
import org.jboss.tattletale.reporting.DependsOnReport;
import org.jboss.tattletale.reporting.Dump;
import org.jboss.tattletale.reporting.EarReport;
import org.jboss.tattletale.reporting.EliminateJarsReport;
import org.jboss.tattletale.reporting.GraphvizReport;
import org.jboss.tattletale.reporting.InvalidVersionReport;
import org.jboss.tattletale.reporting.JarReport;
import org.jboss.tattletale.reporting.MultipleJarsReport;
import org.jboss.tattletale.reporting.MultipleLocationsReport;
import org.jboss.tattletale.reporting.NoVersionReport;
import org.jboss.tattletale.reporting.OSGiReport;
import org.jboss.tattletale.reporting.PackageDependantsReport;
import org.jboss.tattletale.reporting.PackageDependsOnReport;
import org.jboss.tattletale.reporting.PackageMultipleJarsReport;
import org.jboss.tattletale.reporting.Report;
import org.jboss.tattletale.reporting.SealedReport;
import org.jboss.tattletale.reporting.SignReport;
import org.jboss.tattletale.reporting.TransitiveDependantsReport;
import org.jboss.tattletale.reporting.TransitiveDependsOnReport;
import org.jboss.tattletale.reporting.UnusedJarReport;
import org.jboss.tattletale.reporting.WarReport;
import org.jboss.tattletale.utils.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private String source = ".";
    private String destination = ".";
    private String configuration = null;
    private String filter = null;
    private String classloaderStructure = null;
    private String profiles = null;
    private String excludes = null;
    private String blacklisted = null;
    private boolean failOnInfo = false;
    private boolean failOnWarn = false;
    private boolean failOnError = false;
    private boolean deleteOutputDirectory = true;
    private String reports = null;
    private String scan = ".jar,.war,.ear";
    private final List<Class> dependencyReports = new ArrayList<Class>();
    private final List<Class> generalReports;
    private final List<Class> customReports;

    public Main() {
        this.addDependencyReport(ClassDependsOnReport.class);
        this.addDependencyReport(ClassDependantsReport.class);
        this.addDependencyReport(DependsOnReport.class);
        this.addDependencyReport(DependantsReport.class);
        this.addDependencyReport(PackageDependantsReport.class);
        this.addDependencyReport(PackageDependsOnReport.class);
        this.addDependencyReport(TransitiveDependsOnReport.class);
        this.addDependencyReport(TransitiveDependantsReport.class);
        this.addDependencyReport(CircularDependencyReport.class);
        this.addDependencyReport(GraphvizReport.class);
        this.generalReports = new ArrayList<Class>();
        this.addGeneralReport(AS7Report.class);
        this.addGeneralReport(MultipleJarsReport.class);
        this.addGeneralReport(MultipleLocationsReport.class);
        this.addGeneralReport(PackageMultipleJarsReport.class);
        this.addGeneralReport(EliminateJarsReport.class);
        this.addGeneralReport(NoVersionReport.class);
        this.addGeneralReport(ClassLocationReport.class);
        this.addGeneralReport(OSGiReport.class);
        this.addGeneralReport(SignReport.class);
        this.addGeneralReport(SealedReport.class);
        this.addGeneralReport(InvalidVersionReport.class);
        this.addGeneralReport(BlackListedReport.class);
        this.addGeneralReport(UnusedJarReport.class);
        this.customReports = new ArrayList<Class>();
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setClassLoaderStructure(String cls) {
        this.classloaderStructure = cls;
    }

    public void setProfiles(String profiles) {
        this.profiles = profiles;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public final void addDependencyReport(Class clazz) {
        this.dependencyReports.add(clazz);
    }

    public final void addGeneralReport(Class clazz) {
        this.generalReports.add(clazz);
    }

    public final void addCustomReport(Class clazz) {
        this.customReports.add(clazz);
    }

    public void setBlacklisted(String blacklisted) {
        this.blacklisted = blacklisted;
    }

    public void setFailOnInfo(boolean b) {
        this.failOnInfo = b;
    }

    public void setFailOnWarn(boolean b) {
        this.failOnWarn = b;
    }

    public void setFailOnError(boolean b) {
        this.failOnError = b;
    }

    public void setDeleteOutputDirectory(boolean b) {
        this.deleteOutputDirectory = b;
    }

    public void setReports(String reports) {
        this.reports = reports;
    }

    public void setScan(String scan) {
        this.scan = scan;
    }

    public void execute() throws Exception {
        AbstractProfile[] profiles;
        String token;
        StringTokenizer st;
        Properties config = null;
        Properties filters = null;
        config = this.configuration != null ? Configuration.loadFromFile(this.configuration) : Configuration.load("jboss-tattletale.properties");
        filters = this.filter != null ? this.loadFilters() : this.loadDefaultFilters();
        HashSet<String> profileSet = null;
        boolean allProfiles = false;
        HashSet<String> blacklistedSet = null;
        HashSet<String> excludeSet = null;
        boolean allReports = false;
        HashSet<String> reportSet = null;
        if (this.classloaderStructure == null) {
            this.classloaderStructure = config.getProperty("classloader");
        }
        if (this.profiles != null) {
            profileSet = new HashSet<String>();
            st = new StringTokenizer(this.profiles, ",");
            while (st.hasMoreTokens()) {
                token = st.nextToken().trim();
                if ("*".equals(token)) {
                    allProfiles = true;
                    continue;
                }
                allProfiles = false;
                profileSet.add(token);
            }
        }
        if (profileSet == null && config.getProperty("profiles") != null) {
            profileSet = new HashSet();
            st = new StringTokenizer(config.getProperty("profiles"), ",");
            while (st.hasMoreTokens()) {
                token = st.nextToken().trim();
                if ("*".equals(token)) {
                    allProfiles = true;
                    continue;
                }
                allProfiles = false;
                profileSet.add(token);
            }
        }
        if (this.blacklisted != null) {
            blacklistedSet = new HashSet<String>();
            st = new StringTokenizer(this.blacklisted, ",");
            while (st.hasMoreTokens()) {
                token = st.nextToken().trim();
                if (token.endsWith(".*")) {
                    token.substring(0, token.indexOf(".*"));
                }
                if (token.endsWith(".class")) {
                    token.substring(0, token.indexOf(".class"));
                }
                blacklistedSet.add(token);
            }
        }
        if (blacklistedSet == null && config.getProperty("blacklisted") != null) {
            blacklistedSet = new HashSet();
            st = new StringTokenizer(config.getProperty("blacklisted"), ",");
            while (st.hasMoreTokens()) {
                token = st.nextToken().trim();
                if (token.endsWith(".*")) {
                    token.substring(0, token.indexOf(".*"));
                }
                if (token.endsWith(".class")) {
                    token.substring(0, token.indexOf(".class"));
                }
                blacklistedSet.add(token);
            }
        }
        if (this.excludes != null) {
            excludeSet = new HashSet<String>();
            excludeSet.addAll(this.parseExcludes(this.excludes));
        }
        if (excludeSet == null && config.getProperty("excludes") != null) {
            excludeSet = new HashSet();
            excludeSet.addAll(this.parseExcludes(config.getProperty("excludes")));
        }
        if (this.reports == null) {
            this.reports = config.getProperty("reports");
        }
        if (this.reports == null || this.reports != null && this.reports.trim().equals("*")) {
            allReports = true;
        }
        if (!allReports && this.reports != null) {
            reportSet = new HashSet<String>();
            st = new StringTokenizer(this.reports, ",");
            while (st.hasMoreTokens()) {
                token = st.nextToken().trim();
                reportSet.add(token);
            }
        }
        if (!allReports && reportSet == null && config.getProperty("reports") != null) {
            reportSet = new HashSet();
            st = new StringTokenizer(config.getProperty("reports"), ",");
            while (st.hasMoreTokens()) {
                token = st.nextToken().trim();
                reportSet.add(token);
            }
        }
        if (!allReports && reportSet == null) {
            allReports = true;
        }
        if (this.classloaderStructure == null || this.classloaderStructure.trim().equals("")) {
            this.classloaderStructure = "org.jboss.tattletale.reporting.classloader.NoopClassLoaderStructure";
        }
        if (this.scan != null) {
            DirectoryScanner.setArchives(this.scan);
        } else {
            DirectoryScanner.setArchives(".jar, .war, .ear");
        }
        HashMap<String, TreeSet<Location>> locationsMap = new HashMap<String, TreeSet<Location>>();
        TreeSet<Archive> archives = new TreeSet<Archive>();
        TreeMap<String, SortedSet<String>> gProvides = new TreeMap<String, SortedSet<String>>();
        ArrayList<Profile> known = new ArrayList<Profile>();
        for (AbstractProfile p : profiles = new AbstractProfile[]{new SunJava5(), new SunJava6(), new JavaEE5(), new JavaEE6(), new CDI10(), new Seam22(), new Spring25(), new Spring30(), new JBossAS7Profile()}) {
            if (!p.included(allProfiles, profileSet)) continue;
            known.add(p);
        }
        StringTokenizer st2 = new StringTokenizer(this.source, "#");
        ArrayList<File> fileList = new ArrayList<File>();
        Analyzer analyzer = new Analyzer();
        while (st2.hasMoreTokens()) {
            File f = new File(st2.nextToken());
            if (f.isDirectory()) {
                fileList.addAll(DirectoryScanner.scan(f, excludeSet));
                continue;
            }
            fileList.add(f);
        }
        for (File file : fileList) {
            Archive archive;
            ArchiveScanner scanner = analyzer.getScanner(file);
            if (scanner == null || (archive = scanner.scan(file, gProvides, known, blacklistedSet)) == null) continue;
            TreeSet<Location> locations = (TreeSet<Location>)locationsMap.get(archive.getName());
            if (locations == null) {
                locations = new TreeSet<Location>();
            }
            locations.addAll(archive.getLocations());
            locationsMap.put(archive.getName(), locations);
            if (archives.contains(archive)) continue;
            archives.add(archive);
        }
        for (Archive a : archives) {
            SortedSet locations = (SortedSet)locationsMap.get(a.getName());
            for (Location l : locations) {
                a.addLocation(l);
            }
        }
        if (archives != null && archives.size() > 0) {
            ReportSetBuilder reportSetBuilder = new ReportSetBuilder(this.destination, allReports, reportSet, filters);
            reportSetBuilder.addReportParameter("setCLS", this.classloaderStructure);
            reportSetBuilder.addReportParameter("setKnown", known);
            reportSetBuilder.addReportParameter("setArchives", archives);
            reportSetBuilder.addReportParameter("setConfig", config);
            reportSetBuilder.addReportParameter("setGlobalProvides", gProvides);
            this.loadCustomReports(config);
            this.outputReport(reportSetBuilder, archives);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadConfiguration() {
        Properties properties = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.configuration);
            properties.load(fis);
        }
        catch (IOException e) {
            System.err.println("Unable to open " + this.configuration);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadDefaultConfiguration() {
        FileInputStream fis;
        Properties properties = new Properties();
        String propertiesFile = System.getProperty("jboss-tattletale.properties");
        boolean loaded = false;
        if (propertiesFile != null) {
            fis = null;
            try {
                fis = new FileInputStream(propertiesFile);
                properties.load(fis);
                loaded = true;
            }
            catch (IOException e) {
                System.err.println("Unable to open " + propertiesFile);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        if (!loaded) {
            fis = null;
            try {
                fis = new FileInputStream("jboss-tattletale.properties");
                properties.load(fis);
                loaded = true;
            }
            catch (IOException ignore) {
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        if (!loaded) {
            InputStream is = null;
            try {
                ClassLoader cl = Main.class.getClassLoader();
                is = cl.getResourceAsStream("jboss-tattletale.properties");
                properties.load(is);
                loaded = true;
            }
            catch (Exception ie) {
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCustomReports(Properties config) {
        FileInputStream inputStream = null;
        try {
            int index = 1;
            String keyString = "customreport." + index;
            while (config.getProperty(keyString) != null) {
                ClassLoader cl = Main.class.getClassLoader();
                String reportName = config.getProperty(keyString);
                Class<?> customReportClass = Class.forName(reportName, true, cl);
                this.addCustomReport(customReportClass);
                keyString = "customreport." + ++index;
            }
        }
        catch (Exception e) {
            System.err.println("Exception of type: " + e.getClass().toString() + " thrown in loadCustomReports() in org.jboss.tattletale.Main");
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadFilters() {
        Properties properties = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.filter);
            properties.load(fis);
        }
        catch (IOException e) {
            System.err.println("Unable to open " + this.filter);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadDefaultFilters() {
        FileInputStream fis;
        Properties properties = new Properties();
        String propertiesFile = System.getProperty("jboss-tattletale-filter.properties");
        boolean loaded = false;
        if (propertiesFile != null) {
            fis = null;
            try {
                fis = new FileInputStream(propertiesFile);
                properties.load(fis);
                loaded = true;
            }
            catch (IOException e) {
                System.err.println("Unable to open " + propertiesFile);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        if (!loaded) {
            fis = null;
            try {
                fis = new FileInputStream("jboss-tattletale-filter.properties");
                properties.load(fis);
                loaded = true;
            }
            catch (IOException ignore) {
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        return properties;
    }

    private void outputReport(ReportSetBuilder reportSetBuilder, SortedSet<Archive> archives) throws Exception {
        reportSetBuilder.clear();
        for (Class reportDef : this.dependencyReports) {
            reportSetBuilder.addReport(reportDef);
        }
        SortedSet<Report> dependencyReportSet = reportSetBuilder.getReportSet();
        reportSetBuilder.clear();
        for (Class reportDef : this.generalReports) {
            reportSetBuilder.addReport(reportDef);
        }
        SortedSet<Report> generalReportSet = reportSetBuilder.getReportSet();
        reportSetBuilder.clear();
        for (Class reportDef : this.customReports) {
            reportSetBuilder.addReport(reportDef);
        }
        SortedSet<Report> customReportSet = reportSetBuilder.getReportSet();
        reportSetBuilder.clear();
        this.addJarReports(archives, reportSetBuilder);
        SortedSet<Report> archiveReports = reportSetBuilder.getReportSet();
        String outputDir = reportSetBuilder.getOutputDir();
        Dump.generateIndex(dependencyReportSet, generalReportSet, archiveReports, customReportSet, outputDir);
        Dump.generateCSS(outputDir);
        if (this.failOnInfo || this.failOnWarn || this.failOnError) {
            FailureCheck failureCheck = new FailureCheck();
            failureCheck.processReports(dependencyReportSet);
            failureCheck.processReports(generalReportSet);
            failureCheck.processReports(customReportSet);
            failureCheck.processReports(archiveReports);
            if (failureCheck.errorReport() != null) {
                throw new Exception(failureCheck.errorReport());
            }
        }
    }

    private Set<String> parseExcludes(String s) {
        HashSet<String> result = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.startsWith("**")) {
                token = token.substring(2);
            }
            if (token.endsWith("**")) {
                token = token.substring(0, token.indexOf("**"));
            }
            result.add(token);
        }
        return result;
    }

    private static void usage() {
        System.out.println("Usage: Tattletale [-exclude=<excludes>] <source>[#<source>]* [output-directory]");
    }

    private void addJarReports(Collection<Archive> archives, ReportSetBuilder reportSetBuilder) {
        for (Archive a : archives) {
            NestableArchive na;
            if (a.getType() == 2) {
                na = (NestableArchive)a;
                reportSetBuilder.addReport(new WarReport(na));
                continue;
            }
            if (a.getType() == 1) {
                reportSetBuilder.addReport(new JarReport(a));
                continue;
            }
            if (a.getType() != 3) continue;
            na = (NestableArchive)a;
            reportSetBuilder.addReport(new EarReport(na));
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            try {
                int arg = 0;
                Main main = new Main();
                if (args[arg].startsWith("-exclude=")) {
                    main.setExcludes(args[arg].substring(args[arg].indexOf("=") + 1));
                    ++arg;
                }
                main.setSource(args[arg]);
                main.setDestination(args.length > arg + 1 ? args[arg + 1] : ".");
                main.setFailOnInfo(false);
                main.setFailOnWarn(false);
                main.setFailOnError(false);
                main.setDeleteOutputDirectory(true);
                main.execute();
            }
            catch (Exception e) {
                System.err.println("Exception: " + e.getMessage());
                e.printStackTrace(System.err);
            }
        } else {
            Main.usage();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReportSetBuilder {
        private final boolean allReports;
        private final String outputDir;
        private final Properties filters;
        private Set<String> reportSet;
        private SortedSet<Report> returnReportSet = new TreeSet<Report>();
        private final Map<String, Object> reportParameters = new HashMap<String, Object>();

        ReportSetBuilder(String destination, boolean allReports, Set<String> reportSet, Properties filters) throws Exception {
            this.outputDir = this.setupOutputDir(destination);
            this.allReports = allReports;
            this.reportSet = reportSet;
            this.filters = filters;
        }

        public void addReportParameter(String setMethodName, Object parameter) {
            this.reportParameters.put(setMethodName, parameter);
        }

        void clear() {
            this.returnReportSet = new TreeSet<Report>();
        }

        void addReport(Report report) {
            if (this.allReports || this.reportSet.contains(report.getId())) {
                if (this.filters != null && this.filters.getProperty(report.getId()) != null) {
                    report.setFilter(this.filters.getProperty(report.getId()));
                }
                report.generate(this.outputDir);
                this.returnReportSet.add(report);
            }
        }

        void addReport(Class reportDef) throws Exception {
            Method[] allMethods;
            Report report = (Report)reportDef.getConstructor(new Class[0]).newInstance(new Object[0]);
            for (Method m : allMethods = reportDef.getMethods()) {
                if (!this.reportParameters.containsKey(m.getName())) continue;
                m.invoke((Object)report, this.reportParameters.get(m.getName()));
            }
            this.addReport(report);
        }

        SortedSet<Report> getReportSet() {
            return this.returnReportSet;
        }

        String getOutputDir() {
            return this.outputDir;
        }

        private String setupOutputDir(String outputDir) throws IOException {
            File outputDirFile = new File(outputDir = !outputDir.substring(outputDir.length() - 1).equals(File.separator) ? outputDir + File.separator : outputDir);
            if (outputDirFile.exists()) {
                if (Main.this.deleteOutputDirectory) {
                    if (!outputDirFile.equals(new File("."))) {
                        this.recursiveDelete(outputDirFile);
                    }
                } else {
                    throw new IOException("Directory: " + outputDir + " exists");
                }
            }
            if (!outputDirFile.equals(new File(".")) && !outputDirFile.mkdirs()) {
                throw new IOException("Cannot create directory: " + outputDir);
            }
            return outputDir;
        }

        private void recursiveDelete(File f) throws IOException {
            if (f != null && f.exists()) {
                File[] files = f.listFiles();
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        if (files[i].isDirectory()) {
                            this.recursiveDelete(files[i]);
                            continue;
                        }
                        if (files[i].delete()) continue;
                        throw new IOException("Could not delete " + files[i]);
                    }
                }
                if (!f.delete()) {
                    throw new IOException("Could not delete " + f);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FailureCheck {
        private boolean foundError = false;
        private boolean first = true;
        private StringBuilder stringbuffer = new StringBuilder();

        private FailureCheck() {
        }

        String errorReport() {
            if (this.foundError) {
                return this.stringbuffer.toString();
            }
            return null;
        }

        void processReports(Set<Report> reports) {
            for (Report report : reports) {
                this.processReport(report);
            }
        }

        void processReport(Report report) {
            if ((1 == report.getStatus() || 2 == report.getStatus()) && (0 == report.getSeverity() && Main.this.failOnInfo || 1 == report.getSeverity() && Main.this.failOnWarn || 2 == report.getSeverity() && Main.this.failOnError)) {
                this.appendReportInfo(report);
            }
        }

        void appendReportInfo(Report report) {
            if (!this.first) {
                this.stringbuffer = this.stringbuffer.append(System.getProperty("line.separator"));
            }
            this.stringbuffer = this.stringbuffer.append(report.getId());
            this.stringbuffer = this.stringbuffer.append("=");
            if (1 == report.getStatus()) {
                this.stringbuffer = this.stringbuffer.append("YELLOW");
            } else if (2 == report.getStatus()) {
                this.stringbuffer = this.stringbuffer.append("RED");
            }
            this.foundError = true;
            this.first = false;
        }
    }
}

