/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.core.Location;
import org.jboss.tattletale.core.NestableArchive;
import org.jboss.tattletale.reporting.AbstractReport;
import org.jboss.tattletale.reporting.Dump;
import org.jboss.tattletale.reporting.Filter;
import org.jboss.tattletale.reporting.KeyFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoVersionReport
extends AbstractReport {
    private static final String NAME = "No version";
    private static final String DIRECTORY = "noversion";

    public NoVersionReport() {
        super(DIRECTORY, 2, NAME, DIRECTORY);
    }

    @Override
    public void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.newLine());
        bw.write("  <tr>" + Dump.newLine());
        bw.write("     <th>Name</th>" + Dump.newLine());
        bw.write("     <th>Location</th>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        this.recursivelyWriteContent(bw, this.archives);
        bw.write("</table>" + Dump.newLine());
    }

    private void recursivelyWriteContent(BufferedWriter bw, Collection<Archive> archives) throws IOException {
        boolean odd = true;
        for (Archive archive : archives) {
            if (archive instanceof NestableArchive) {
                NestableArchive nestableArchive = (NestableArchive)archive;
                this.recursivelyWriteContent(bw, nestableArchive.getSubArchives());
                continue;
            }
            SortedSet<Location> locations = archive.getLocations();
            Iterator lit = locations.iterator();
            Location location2 = (Location)lit.next();
            boolean include = false;
            boolean filtered = this.isFiltered(archive.getName());
            while (!include && lit.hasNext()) {
                location2 = (Location)lit.next();
                if (location2.getVersion() != null) continue;
                include = true;
                if (filtered) continue;
                this.status = 2;
            }
            if (!include) continue;
            if (odd) {
                bw.write("  <tr class=\"rowodd\">" + Dump.newLine());
            } else {
                bw.write("  <tr class=\"roweven\">" + Dump.newLine());
            }
            bw.write("     <td><a href=\"../jar/" + archive.getName() + ".html\">" + archive.getName() + "</a></td>" + Dump.newLine());
            bw.write("     <td>");
            bw.write("       <table>" + Dump.newLine());
            for (Location location2 : locations) {
                bw.write("      <tr>" + Dump.newLine());
                bw.write("        <td>" + location2.getFilename() + "</td>" + Dump.newLine());
                if (!filtered) {
                    bw.write("        <td>");
                } else {
                    bw.write("        <td style=\"text-decoration: line-through;\">");
                }
                if (location2.getVersion() != null) {
                    bw.write(location2.getVersion());
                } else {
                    bw.write("<i>Not listed</i>");
                }
                bw.write("</td>" + Dump.newLine());
                bw.write("      </tr>" + Dump.newLine());
            }
            bw.write("       </table>" + Dump.newLine());
            bw.write("</td>" + Dump.newLine());
            bw.write("  </tr>" + Dump.newLine());
            odd = !odd;
        }
    }

    @Override
    public void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.newLine());
        bw.write(Dump.newLine());
        bw.write("<h1>No version</h1>" + Dump.newLine());
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.newLine());
        bw.write("<p>" + Dump.newLine());
    }

    @Override
    protected Filter createFilter() {
        return new KeyFilter();
    }
}

