/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.util;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.WriteBuffer;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayBuffer;
import java.nio.ByteBuffer;

public class WriteByteBuffer
implements WriteBuffer {
    public static final int DEFAULT_CAPACITY = 64;
    public static final int MAX_BUFFER_CAPACITY = 0x8000000;
    private ByteBuffer buffer;

    public WriteByteBuffer() {
        this(64);
    }

    public WriteByteBuffer(int capacity) {
        Preconditions.checkArgument((capacity <= 0x8000000 ? 1 : 0) != 0, (String)"Capacity exceeds max buffer capacity: %s", (Object[])new Object[]{0x8000000});
        this.buffer = ByteBuffer.allocate(capacity);
    }

    private void require(int size) {
        if (this.buffer.capacity() - this.buffer.position() < size) {
            int newcapacity = this.buffer.position() + size + this.buffer.capacity();
            Preconditions.checkArgument((newcapacity <= 0x8000000 ? 1 : 0) != 0, (String)"Capacity exceeds max buffer capacity: %s", (Object[])new Object[]{0x8000000});
            ByteBuffer newBuffer = ByteBuffer.allocate(newcapacity);
            this.buffer.flip();
            newBuffer.put(this.buffer);
            this.buffer = newBuffer;
        }
    }

    @Override
    public WriteBuffer putLong(long val) {
        this.require(8);
        this.buffer.putLong(val);
        return this;
    }

    @Override
    public WriteBuffer putInt(int val) {
        this.require(4);
        this.buffer.putInt(val);
        return this;
    }

    @Override
    public WriteBuffer putShort(short val) {
        this.require(2);
        this.buffer.putShort(val);
        return this;
    }

    @Override
    public WriteBuffer putBoolean(boolean val) {
        return this.putByte((byte)(val ? 1 : 0));
    }

    @Override
    public WriteBuffer putByte(byte val) {
        this.require(1);
        this.buffer.put(val);
        return this;
    }

    @Override
    public WriteBuffer putBytes(byte[] val) {
        this.require(1 * val.length);
        this.buffer.put(val);
        return this;
    }

    @Override
    public WriteBuffer putBytes(final StaticBuffer val) {
        this.require(1 * val.length());
        val.as(new StaticBuffer.Factory<Boolean>(){

            @Override
            public Boolean get(byte[] array, int offset, int limit) {
                WriteByteBuffer.this.buffer.put(array, offset, val.length());
                return Boolean.TRUE;
            }
        });
        return this;
    }

    @Override
    public WriteBuffer putChar(char val) {
        this.require(2);
        this.buffer.putChar(val);
        return this;
    }

    @Override
    public WriteBuffer putFloat(float val) {
        this.require(4);
        this.buffer.putFloat(val);
        return this;
    }

    @Override
    public WriteBuffer putDouble(double val) {
        this.require(8);
        this.buffer.putDouble(val);
        return this;
    }

    @Override
    public int getPosition() {
        return this.buffer.position();
    }

    @Override
    public StaticBuffer getStaticBuffer() {
        return this.getStaticBufferFlipBytes(0, 0);
    }

    @Override
    public StaticBuffer getStaticBufferFlipBytes(int from, int to) {
        ByteBuffer b = this.buffer.duplicate();
        b.flip();
        Preconditions.checkArgument((from >= 0 && from <= to ? 1 : 0) != 0);
        Preconditions.checkArgument((to <= b.limit() ? 1 : 0) != 0);
        for (int i = from; i < to; ++i) {
            b.put(i, ~b.get(i));
        }
        return StaticArrayBuffer.of(b);
    }
}

