/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.versions;

import java.util.ArrayList;
import org.jboss.forge.furnace.versions.MultipleVersionRange;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.forge.furnace.versions.VersionRange;

public class DefaultVersionRange
implements VersionRange {
    private final Version min;
    private final Version max;
    private final boolean minInclusive;
    private final boolean maxInclusive;
    public static final DefaultVersionRange EVERYTHING = new DefaultVersionRange(null, false, null, false);

    public DefaultVersionRange(Version min, boolean minInclusive, Version max, boolean maxInclusive) {
        this.min = min;
        this.minInclusive = minInclusive;
        this.max = max;
        this.maxInclusive = maxInclusive;
    }

    @Override
    public Version getMin() {
        return this.min;
    }

    @Override
    public boolean isMinInclusive() {
        return this.minInclusive;
    }

    @Override
    public Version getMax() {
        return this.max;
    }

    @Override
    public boolean isMaxInclusive() {
        return this.maxInclusive;
    }

    @Override
    public boolean isEmpty() {
        return this.min.compareTo(this.max) == 0 && !this.minInclusive && !this.maxInclusive;
    }

    @Override
    public boolean isExact() {
        return this.min.equals(this.max);
    }

    @Override
    public VersionRange getIntersection(VersionRange ... ranges) {
        ArrayList<VersionRange> list = new ArrayList<VersionRange>();
        for (VersionRange range : ranges) {
            list.add(range);
        }
        MultipleVersionRange intersection = new MultipleVersionRange(list);
        return new DefaultVersionRange(intersection.getMin(), intersection.isMinInclusive(), intersection.getMax(), intersection.isMaxInclusive());
    }

    @Override
    public boolean includes(Version version) {
        int comparison;
        if (this.min != null) {
            comparison = this.min.compareTo(version);
            if (comparison == 0 && !this.minInclusive) {
                return false;
            }
            if (comparison > 0) {
                return false;
            }
        }
        if (this.max != null) {
            comparison = this.max.compareTo(version);
            if (comparison == 0 && !this.maxInclusive) {
                return false;
            }
            if (comparison < 0) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = 13;
        result = this.min == null ? ++result : (result += this.min.hashCode());
        result *= this.minInclusive ? 1 : 2;
        result = this.max == null ? (result -= 3) : (result -= this.max.hashCode());
        return result *= this.maxInclusive ? 2 : 3;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DefaultVersionRange)) {
            return false;
        }
        DefaultVersionRange restriction = (DefaultVersionRange)other;
        if (this.min != null ? !this.min.equals(restriction.min) : restriction.min != null) {
            return false;
        }
        if (this.minInclusive != restriction.minInclusive) {
            return false;
        }
        if (this.max != null ? !this.max.equals(restriction.max) : restriction.max != null) {
            return false;
        }
        return this.maxInclusive == restriction.maxInclusive;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.isMinInclusive() ? "[" : "(");
        if (this.getMin() != null) {
            buf.append(this.getMin().toString());
        }
        if (this.getMax() != null) {
            if (!this.getMax().equals(this.getMin())) {
                buf.append(",");
                buf.append(this.getMax().toString());
            }
        } else {
            buf.append(",");
        }
        buf.append(this.isMaxInclusive() ? "]" : ")");
        return buf.toString();
    }
}

