/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker;

import freemarker.ext.beans.BeanModel;
import freemarker.template.DefaultListAdapter;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateModelException;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.model.comparator.FilePathComparator;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.exception.WindupException;

public class SortFilesByPathMethod
implements WindupFreeMarkerMethod {
    private static final String NAME = "sortFilesByPathAscending";

    public String getMethodName() {
        return NAME;
    }

    public String getDescription() {
        return "Takes an Iterable<" + FileModel.class.getSimpleName() + "> or Iterable<String> and returns them, ordered alphabetically.";
    }

    public Object exec(List arguments) throws TemplateModelException {
        ExecutionStatistics.get().begin(NAME);
        if (arguments.size() != 1) {
            throw new TemplateModelException("Error, method expects one argument (Iterable<FileModel>)");
        }
        Iterable<Object> pathIterable = this.getIterable(arguments.get(0));
        Comparator<Object> fileModelComparator = new Comparator<Object>(){
            final FilePathComparator filePathComparator = new FilePathComparator();

            @Override
            public int compare(Object o1, Object o2) {
                return this.filePathComparator.compare(this.getFilePath(o1), this.getFilePath(o2));
            }

            private String getFilePath(Object o) {
                if (o == null) {
                    return null;
                }
                if (o instanceof FileModel) {
                    return ((FileModel)o).getFilePath();
                }
                if (o instanceof String) {
                    return (String)o;
                }
                throw new IllegalArgumentException("Unrecognized type: " + o.getClass().getName());
            }
        };
        TreeSet<Object> resultSet = new TreeSet<Object>(fileModelComparator);
        for (Object fm : pathIterable) {
            resultSet.add(fm);
        }
        ExecutionStatistics.get().end(NAME);
        return resultSet;
    }

    private Iterable<Object> getIterable(Object arg) throws TemplateModelException {
        if (arg instanceof BeanModel) {
            BeanModel beanModel = (BeanModel)arg;
            return (Iterable)beanModel.getWrappedObject();
        }
        if (arg instanceof SimpleSequence) {
            SimpleSequence simpleSequence = (SimpleSequence)arg;
            return simpleSequence.toList();
        }
        if (arg instanceof DefaultListAdapter) {
            DefaultListAdapter defaultListAdapter = (DefaultListAdapter)arg;
            return (Iterable)defaultListAdapter.getWrappedObject();
        }
        throw new WindupException("Unrecognized type passed to: " + this.getMethodName() + ": " + arg.getClass().getCanonicalName());
    }

    public void setContext(GraphRewrite event) {
    }
}

