/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.xml;

import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.exception.ConfigurationException;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.reporting.category.IssueCategory;
import org.jboss.windup.reporting.category.IssueCategoryRegistry;
import org.jboss.windup.reporting.config.Link;
import org.jboss.windup.reporting.config.classification.Classification;
import org.jboss.windup.reporting.model.IssueDisplayMode;
import org.jboss.windup.reporting.quickfix.Quickfix;
import org.jboss.windup.reporting.xml.HintHandler;
import org.jboss.windup.util.exception.WindupException;
import org.joox.JOOX;
import org.ocpsoft.rewrite.context.Context;
import org.w3c.dom.Element;

@NamespaceElementHandler(elementName="classification", namespace="http://windup.jboss.org/schema/jboss-ruleset")
public class ClassificationHandler
implements ElementHandler<Classification> {
    public Classification processElement(ParserContext handlerManager, Element element) throws ConfigurationException {
        String description;
        String issueDisplayModeString;
        String classificationStr = JOOX.$((Element)element).attr("title");
        if (StringUtils.isBlank((CharSequence)classificationStr)) {
            throw new WindupException("Error, 'classification' element must have a non-empty 'title' attribute (eg, 'Decompiled Source File')");
        }
        String of = JOOX.$((Element)element).attr("of");
        String effortStr = JOOX.$((Element)element).attr("effort");
        String issueCategoryID = JOOX.$((Element)element).attr("category-id");
        if (StringUtils.isBlank((CharSequence)issueCategoryID)) {
            issueCategoryID = JOOX.$((Element)element).attr("severity");
        }
        HashSet<String> tags = new HashSet<String>();
        Classification classification = (Classification)Classification.as((String)classificationStr);
        if (of != null) {
            classification.setVariableName(of);
        }
        if (StringUtils.isNotBlank((CharSequence)effortStr)) {
            try {
                int effort = Integer.parseInt(effortStr);
                classification.withEffort(effort);
            }
            catch (NumberFormatException e) {
                throw new WindupException("Could not parse effort level: " + effortStr + " as an integer!");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)issueCategoryID)) {
            IssueCategoryRegistry issueCategoryRegistry = IssueCategoryRegistry.instance((Context)handlerManager.getRuleLoaderContext().getContext());
            IssueCategory issueCategory = issueCategoryRegistry.getByID(issueCategoryID);
            classification.withIssueCategory(issueCategory);
        }
        if (StringUtils.isNotBlank((CharSequence)(issueDisplayModeString = JOOX.$((Element)element).attr("issue-display-mode")))) {
            IssueDisplayMode issueDisplayMode = IssueDisplayMode.parse((String)issueDisplayModeString);
            classification.withIssueDisplayMode(issueDisplayMode);
        }
        if (StringUtils.isNotBlank((CharSequence)(description = JOOX.$((Element)element).child("description").text()))) {
            description = HintHandler.trimLeadingAndTrailingSpaces(description);
            classification.withDescription(description);
        }
        List children = JOOX.$((Element)element).children("link").get();
        for (Element child : children) {
            Link link = (Link)handlerManager.processElement(child);
            classification.with(link);
        }
        children = JOOX.$((Element)element).children("tag").get();
        for (Element child : children) {
            tags.add(child.getTextContent());
        }
        classification.withTags(tags);
        children = JOOX.$((Element)element).children("quickfix").get();
        for (Element child : children) {
            Quickfix quickfix = (Quickfix)handlerManager.processElement(child);
            classification.withQuickfix(quickfix);
        }
        return classification;
    }
}

