/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.loader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.forge.furnace.proxy.Proxies;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.RuleProvider;
import org.jboss.windup.config.phase.RulePhase;
import org.jboss.windup.util.exception.WindupMultiStringException;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.CycleDetector;
import org.jgrapht.graph.DefaultDirectedWeightedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.traverse.TopologicalOrderIterator;

public class RuleProviderSorter {
    private List<RuleProvider> providers;
    private final IdentityHashMap<Class<? extends RuleProvider>, RuleProvider> classToProviderMap = new IdentityHashMap();
    private final Map<String, RuleProvider> idToProviderMap = new HashMap<String, RuleProvider>();

    private RuleProviderSorter(List<RuleProvider> providers) {
        this.providers = new ArrayList<RuleProvider>(providers);
        this.initializeLookupCaches();
        this.sort();
    }

    public static List<RuleProvider> sort(List<RuleProvider> providers) {
        RuleProviderSorter sorter = new RuleProviderSorter(providers);
        return sorter.getProviders();
    }

    private List<RuleProvider> getProviders() {
        return this.providers;
    }

    private void initializeLookupCaches() {
        for (RuleProvider provider : this.providers) {
            Class<?> unproxiedClass = this.unwrapType(provider.getClass());
            this.classToProviderMap.put(unproxiedClass, provider);
            this.idToProviderMap.put(provider.getMetadata().getID(), provider);
        }
    }

    private void sort() {
        DefaultDirectedWeightedGraph graph = new DefaultDirectedWeightedGraph(DefaultEdge.class);
        for (RuleProvider provider : this.providers) {
            graph.addVertex((Object)provider);
        }
        this.addProviderRelationships((DefaultDirectedWeightedGraph<RuleProvider, DefaultEdge>)graph);
        this.checkForCycles((DefaultDirectedWeightedGraph<RuleProvider, DefaultEdge>)graph);
        ArrayList<RuleProvider> result = new ArrayList<RuleProvider>(this.providers.size());
        TopologicalOrderIterator iterator = new TopologicalOrderIterator((DirectedGraph)graph);
        while (iterator.hasNext()) {
            RuleProvider provider = (RuleProvider)iterator.next();
            result.add(provider);
        }
        this.providers = Collections.unmodifiableList(result);
        int index = 0;
        for (RuleProvider provider : this.providers) {
            if (!(provider instanceof AbstractRuleProvider)) continue;
            ((AbstractRuleProvider)provider).setExecutionIndex(index++);
        }
    }

    private void addProviderRelationships(DefaultDirectedWeightedGraph<RuleProvider, DefaultEdge> graph) {
        this.linkRulePhases();
        for (RuleProvider provider : this.providers) {
            RuleProvider otherProvider;
            RuleProvider phaseProvider = this.getByClass(provider.getMetadata().getPhase());
            LinkedList<String> errors = new LinkedList<String>();
            for (Class clz : provider.getMetadata().getExecuteAfter()) {
                this.addExecuteAfterRelationship(graph, provider, errors, clz);
            }
            if (phaseProvider != null) {
                if (provider.getMetadata().getPhase() != Proxies.unwrap((Object)provider).getClass()) {
                    this.addExecuteAfterRelationship(graph, provider, errors, provider.getMetadata().getPhase());
                }
                for (Class clz : phaseProvider.getMetadata().getExecuteAfter()) {
                    this.addExecuteAfterRelationship(graph, provider, errors, clz);
                }
            }
            for (Class clz : provider.getMetadata().getExecuteBefore()) {
                this.addExecuteBeforeRelationship(graph, provider, errors, clz);
            }
            if (phaseProvider != null) {
                for (Class clz : phaseProvider.getMetadata().getExecuteBefore()) {
                    this.addExecuteBeforeRelationship(graph, provider, errors, clz);
                }
            }
            for (String depID : provider.getMetadata().getExecuteAfterIDs()) {
                otherProvider = this.getByID(depID);
                if (otherProvider == null) {
                    errors.add("RuleProvider " + provider.getMetadata().getID() + " is specified to execute after: " + depID + " but this provider could not be found.");
                    continue;
                }
                graph.addEdge((Object)otherProvider, (Object)provider);
            }
            for (String depID : provider.getMetadata().getExecuteBeforeIDs()) {
                otherProvider = this.getByID(depID);
                if (otherProvider == null) {
                    errors.add("RuleProvider " + provider.getMetadata().getID() + " is specified to execute before: " + depID + " but this provider could not be found.");
                    continue;
                }
                graph.addEdge((Object)provider, (Object)otherProvider);
            }
            if (errors.isEmpty()) continue;
            throw new WindupMultiStringException("Some rules to be executed before or after were not found:", errors);
        }
    }

    private void linkRulePhases() {
        for (RuleProvider provider : this.providers) {
            if (!(provider instanceof RulePhase)) continue;
            if (provider.getMetadata().getExecuteBefore().isEmpty()) {
                for (RuleProvider otherProvider : this.providers) {
                    if (!(otherProvider instanceof RulePhase) || !otherProvider.getMetadata().getExecuteAfter().contains(Proxies.unwrap((Object)provider).getClass())) continue;
                    ((RulePhase)provider).setExecuteBefore(Proxies.unwrap((Object)((RulePhase)otherProvider)).getClass());
                }
            }
            if (!provider.getMetadata().getExecuteAfter().isEmpty()) continue;
            for (RuleProvider otherProvider : this.providers) {
                if (!(otherProvider instanceof RulePhase) || !otherProvider.getMetadata().getExecuteBefore().contains(Proxies.unwrap((Object)provider).getClass())) continue;
                ((RulePhase)provider).setExecuteAfter(Proxies.unwrap((Object)((RulePhase)otherProvider)).getClass());
            }
        }
    }

    private void addExecuteBeforeRelationship(DefaultDirectedWeightedGraph<RuleProvider, DefaultEdge> graph, RuleProvider provider, List<String> errors, Class<? extends RuleProvider> clz) {
        RuleProvider otherProvider = this.getByClass(clz);
        if (otherProvider == null) {
            errors.add("RuleProvider " + provider.getMetadata().getID() + " is specified to execute before: " + clz.getName() + " but this class could not be found.");
        } else {
            graph.addEdge((Object)provider, (Object)otherProvider);
        }
    }

    private void addExecuteAfterRelationship(DefaultDirectedWeightedGraph<RuleProvider, DefaultEdge> graph, RuleProvider provider, List<String> errors, Class<? extends RuleProvider> clz) {
        RuleProvider otherProvider = this.getByClass(clz);
        if (otherProvider == null) {
            errors.add("RuleProvider " + provider.getMetadata().getID() + " is specified to execute after class: " + clz.getName() + " but this class could not be found.");
        } else {
            graph.addEdge((Object)otherProvider, (Object)provider);
        }
    }

    private void checkForCycles(DefaultDirectedWeightedGraph<RuleProvider, DefaultEdge> graph) {
        CycleDetector cycleDetector = new CycleDetector(graph);
        if (cycleDetector.detectCycles()) {
            Set cycles = cycleDetector.findCycles();
            StringBuilder errorSB = new StringBuilder();
            for (RuleProvider cycle : cycles) {
                errorSB.append("Found dependency cycle involving: " + cycle.getMetadata().getID() + "\n");
                Set subCycleSet = cycleDetector.findCyclesContainingVertex((Object)cycle);
                for (RuleProvider subCycle : subCycleSet) {
                    errorSB.append("\tSubcycle: " + subCycle.getMetadata().getID() + "\n");
                }
            }
            throw new RuntimeException("Dependency cycles detected: " + errorSB.toString());
        }
    }

    private RuleProvider getByClass(Class<? extends RuleProvider> c) {
        return this.classToProviderMap.get(c);
    }

    private RuleProvider getByID(String id) {
        return this.idToProviderMap.get(id);
    }

    private <T> Class<T> unwrapType(Class<T> wrapped) {
        return Proxies.unwrapProxyTypes(wrapped, (ClassLoader[])new ClassLoader[0]);
    }
}

