/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.project.condition;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jboss.windup.project.condition.Version;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;

public class Artifact
implements Parameterized {
    private RegexParameterizedPatternParser groupId;
    private RegexParameterizedPatternParser artifactId;
    private Version version;

    public static Artifact withVersion(Version v) {
        Artifact artifact = new Artifact();
        artifact.version = v;
        return artifact;
    }

    public static Artifact withGroupId(String groupId) {
        Artifact artifact = new Artifact();
        artifact.groupId = new RegexParameterizedPatternParser(groupId);
        return artifact;
    }

    public static Artifact withArtifactId(String artifactId) {
        Artifact artifact = new Artifact();
        artifact.artifactId = new RegexParameterizedPatternParser(artifactId);
        return artifact;
    }

    public Artifact andVersion(Version version) {
        this.version = version;
        return this;
    }

    public Artifact andArtifactId(String artifactId) {
        this.artifactId = new RegexParameterizedPatternParser(artifactId);
        return this;
    }

    public ParameterizedPatternParser getGroupId() {
        return this.groupId;
    }

    public ParameterizedPatternParser getArtifactId() {
        return this.artifactId;
    }

    public Version getVersion() {
        return this.version;
    }

    public Set<String> getRequiredParameterNames() {
        return new HashSet<String>(Arrays.asList("groupId", "artifactId"));
    }

    public void setParameterStore(ParameterStore store) {
        if (this.groupId != null) {
            this.groupId.setParameterStore(store);
        }
        if (this.artifactId != null) {
            this.artifactId.setParameterStore(store);
        }
    }
}

