/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.projects.archetype.ui;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.concurrent.Callable;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.DependencyQuery;
import org.jboss.forge.addon.dependencies.DependencyRepository;
import org.jboss.forge.addon.dependencies.DependencyResolver;
import org.jboss.forge.addon.dependencies.builder.DependencyQueryBuilder;
import org.jboss.forge.addon.maven.archetype.ArchetypeCatalogFactory;
import org.jboss.forge.addon.maven.archetype.ArchetypeCatalogFactoryRegistry;
import org.jboss.forge.addon.maven.archetype.ArchetypeHelper;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.command.AbstractUICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.util.Strings;

public class ArchetypeCatalogSelectionWizardStep
extends AbstractUICommand
implements UIWizardStep {
    private UISelectOne<ArchetypeCatalogFactory> catalog;
    private UISelectOne<Archetype> archetype;

    public NavigationResult next(UINavigationContext context) throws Exception {
        return null;
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("Maven: Choose Archetype").description("Choose a Maven archetype for your project");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        ArchetypeCatalogFactoryRegistry archetypeRegistry = (ArchetypeCatalogFactoryRegistry)SimpleContainer.getServices((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ArchetypeCatalogFactoryRegistry.class).get();
        InputComponentFactory factory = builder.getInputComponentFactory();
        this.catalog = (UISelectOne)((UISelectOne)((UISelectOne)((UISelectOne)factory.createSelectOne("catalog", ArchetypeCatalogFactory.class).setLabel("Catalog")).setRequired(true)).setItemLabelConverter((Converter)new Converter<ArchetypeCatalogFactory, String>(){

            public String convert(ArchetypeCatalogFactory source) {
                return source != null ? source.getName() : null;
            }
        })).setValueChoices(archetypeRegistry.getArchetypeCatalogFactories());
        this.archetype = (UISelectOne)((UISelectOne)((UISelectOne)((UISelectOne)((UISelectOne)factory.createSelectOne("archetype", Archetype.class).setLabel("Archetype")).setRequired(true)).setItemLabelConverter((Converter)new Converter<Archetype, String>(){

            public String convert(Archetype source) {
                if (source == null) {
                    return null;
                }
                return source.getGroupId() + ":" + source.getArtifactId() + ":" + source.getVersion();
            }
        })).setValueChoices((Callable)new Callable<Iterable<Archetype>>(){

            @Override
            public Iterable<Archetype> call() throws Exception {
                ArchetypeCatalogFactory catalogFactory;
                ArchetypeCatalog archetypes;
                LinkedHashSet<Archetype> result = new LinkedHashSet<Archetype>();
                if (ArchetypeCatalogSelectionWizardStep.this.catalog.hasValue() && (archetypes = (catalogFactory = (ArchetypeCatalogFactory)ArchetypeCatalogSelectionWizardStep.this.catalog.getValue()).getArchetypeCatalog()) != null) {
                    result.addAll(archetypes.getArchetypes());
                }
                return result;
            }
        })).setDescription((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                Archetype value = (Archetype)ArchetypeCatalogSelectionWizardStep.this.archetype.getValue();
                return value == null ? null : value.getDescription();
            }
        });
        builder.add(this.catalog).add(this.archetype);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        UIContext uiContext = context.getUIContext();
        Project project = (Project)uiContext.getAttributeMap().get(Project.class);
        Archetype chosenArchetype = (Archetype)this.archetype.getValue();
        String coordinate = chosenArchetype.getGroupId() + ":" + chosenArchetype.getArtifactId() + ":" + chosenArchetype.getVersion();
        DependencyQueryBuilder depQuery = DependencyQueryBuilder.create((String)coordinate);
        String repository = chosenArchetype.getRepository();
        if (!Strings.isNullOrEmpty((String)repository)) {
            int lastRepositoryPath;
            if (repository.endsWith(".xml") && (lastRepositoryPath = repository.lastIndexOf(47)) > -1) {
                repository = repository.substring(0, lastRepositoryPath);
            }
            if (!repository.isEmpty()) {
                depQuery.setRepositories(new DependencyRepository[]{new DependencyRepository("archetype", repository)});
            }
        }
        DependencyResolver resolver = (DependencyResolver)SimpleContainer.getServices((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), DependencyResolver.class).get();
        Dependency resolvedArtifact = resolver.resolveArtifact((DependencyQuery)depQuery);
        FileResource artifact = resolvedArtifact.getArtifact();
        MetadataFacet metadataFacet = (MetadataFacet)project.getFacet(MetadataFacet.class);
        File fileRoot = (File)((DirectoryResource)project.getRoot().reify(DirectoryResource.class)).getUnderlyingResourceObject();
        ArchetypeHelper archetypeHelper = new ArchetypeHelper(artifact.getResourceInputStream(), fileRoot, metadataFacet.getProjectGroupName(), metadataFacet.getProjectName(), metadataFacet.getProjectVersion());
        JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        archetypeHelper.setPackageName(facet.getBasePackage());
        archetypeHelper.execute();
        return Results.success();
    }
}

