/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.xml;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.exception.ConfigurationException;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.rules.apps.java.condition.annotation.AnnotationCondition;
import org.jboss.windup.rules.apps.java.condition.annotation.AnnotationTypeCondition;
import org.jboss.windup.rules.apps.java.xml.AnnotationConditionHandler;
import org.jboss.windup.util.exception.WindupException;
import org.joox.JOOX;
import org.w3c.dom.Element;

@NamespaceElementHandler(elementName="annotation-type", namespace="http://windup.jboss.org/schema/jboss-ruleset")
public class AnnotationTypeConditionHandler
extends AnnotationConditionHandler
implements ElementHandler<AnnotationTypeCondition> {
    public static final String ANNOTATION_TYPE = "annotation-type";
    private static final String PATTERN = "pattern";

    public AnnotationTypeCondition processElement(ParserContext handlerManager, Element element) throws ConfigurationException {
        String pattern = element.getAttribute(PATTERN);
        if (StringUtils.isBlank((CharSequence)pattern)) {
            throw new WindupException("Element: annotation-type requires a pattern attribute!");
        }
        AnnotationTypeCondition condition = new AnnotationTypeCondition(pattern);
        List children = JOOX.$((Element)element).children().get();
        for (Element child : children) {
            switch (child.getNodeName()) {
                case "annotation-type": 
                case "annotation-list": 
                case "annotation-literal": {
                    String name = child.getAttribute("name");
                    AnnotationCondition annotationCondition = (AnnotationCondition)handlerManager.processElement(child);
                    condition.addCondition(name, annotationCondition);
                }
            }
        }
        return condition;
    }
}

