/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.mavenize;

import java.util.Map;
import java.util.logging.Logger;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.ArchiveExtractionPhase;
import org.jboss.windup.config.phase.ArchiveMetadataExtractionPhase;
import org.jboss.windup.config.phase.DependentPhase;
import org.jboss.windup.config.phase.DiscoverProjectStructurePhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryBuilderFind;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.java.archives.config.ArchiveIdentificationConfigLoadingRuleProvider;
import org.jboss.windup.rules.apps.java.archives.model.ArchiveCoordinateModel;
import org.jboss.windup.rules.apps.java.archives.model.IdentifiedArchiveModel;
import org.jboss.windup.rules.apps.java.condition.SourceMode;
import org.jboss.windup.rules.apps.java.scan.provider.DiscoverMavenHierarchyRuleProvider;
import org.jboss.windup.rules.apps.mavenize.GlobalBomModel;
import org.jboss.windup.rules.apps.mavenize.MavenCoord;
import org.jboss.windup.rules.apps.mavenize.MavenizationService;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(after={ArchiveMetadataExtractionPhase.class, ArchiveIdentificationConfigLoadingRuleProvider.class, ArchiveExtractionPhase.class, DiscoverMavenHierarchyRuleProvider.class, DiscoverProjectStructurePhase.class}, phase=DependentPhase.class)
public class MavenizeRuleProvider
extends AbstractRuleProvider {
    private static final Logger LOG = Logging.get(MavenizeRuleProvider.class);
    public static final MavenCoord JBOSS_PARENT = new MavenCoord("org.jboss", "jboss-parent", "20");
    public static final MavenCoord JBOSS_BOM_JAVAEE6_WITH_ALL = new MavenCoord("org.jboss.bom", "jboss-javaee-6.0-with-all", "1.0.7.Final");
    public static final MavenCoord JBOSS_BOM_JAVAEE7_WITH_ALL = new MavenCoord("org.jboss.bom", "wildfly-javaee7-with-tools", "10.0.1.Final");

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        QueryBuilderFind applicationProjectModels = Query.fromType(WindupConfigurationModel.class);
        return ConfigurationBuilder.begin().addRule().perform((Operation)new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                if (!MavenizeRuleProvider.isPerformMavenization(event.getGraphContext())) {
                    return;
                }
                GlobalBomModel bom = (GlobalBomModel)event.getGraphContext().getFramed().addVertex(null, GlobalBomModel.class);
                ArchiveCoordinateModel jbossParent = (ArchiveCoordinateModel)event.getGraphContext().getFramed().addVertex(null, ArchiveCoordinateModel.class);
                MavenizeRuleProvider.copyTo(JBOSS_PARENT, jbossParent);
                bom.setParent(jbossParent);
            }
        }).withId("Mavenize-BOM-data-collection").addRule().when((Condition)Query.fromType(IdentifiedArchiveModel.class)).perform((Operation)new MavenizePutNewerVersionToGlobalBomOperation()).withId("Mavenize-BOM-file-creation").addRule().when((Condition)applicationProjectModels, new Condition[]{SourceMode.isDisabled()}).perform((Operation)new MavenizeApplicationOperation()).withId("Mavenize-projects-mavenization");
    }

    private static void copyTo(MavenCoord from, ArchiveCoordinateModel to) {
        to.setArtifactId(from.getArtifactId());
        to.setGroupId(from.getGroupId());
        to.setVersion(from.getVersion());
        to.setClassifier(from.getClassifier());
        to.setPackaging(from.getPackaging());
    }

    public static Boolean getBooleanOption(GraphContext graphContext, String name) {
        Map options = graphContext.getOptionMap();
        Object value = options.get(name);
        if (value != null && !(value instanceof Boolean)) {
            throw new IllegalStateException("Option value expected to be Boolean, but was: " + value.getClass());
        }
        return (Boolean)options.get(name);
    }

    public static boolean getBooleanOption(GraphContext graphContext, String name, boolean default_) {
        Boolean val = MavenizeRuleProvider.getBooleanOption(graphContext, name);
        if (val == null) {
            return default_;
        }
        return val;
    }

    private static boolean isPerformMavenization(GraphContext graphContext) {
        return MavenizeRuleProvider.getBooleanOption(graphContext, "mavenize", false);
    }

    private class MavenizeApplicationOperation
    extends AbstractIterationOperation<WindupConfigurationModel> {
        public void perform(GraphRewrite event, EvaluationContext evalContext, WindupConfigurationModel config) {
            if (!MavenizeRuleProvider.isPerformMavenization(event.getGraphContext())) {
                return;
            }
            for (FileModel inputPath : config.getInputPaths()) {
                ProjectModel projectModel = inputPath.getProjectModel();
                if (projectModel == null) {
                    throw new WindupException("Error, no project found in: " + inputPath.getFilePath());
                }
                new MavenizationService(event.getGraphContext()).mavenizeApp(projectModel);
            }
        }
    }

    class MavenizePutNewerVersionToGlobalBomOperation
    extends AbstractIterationOperation<IdentifiedArchiveModel> {
        MavenizePutNewerVersionToGlobalBomOperation() {
        }

        public void perform(GraphRewrite event, EvaluationContext context, IdentifiedArchiveModel archive) {
            if (!MavenizeRuleProvider.isPerformMavenization(event.getGraphContext())) {
                return;
            }
            if (archive.getCoordinate() == null) {
                LOG.info("Warning: archive.getCoordinate() is null: " + archive.toPrettyString());
                return;
            }
            LOG.info("Adding to global BOM: " + archive.getCoordinate().toPrettyString());
            GraphService bomServ = new GraphService(event.getGraphContext(), GlobalBomModel.class);
            GlobalBomModel bom = (GlobalBomModel)bomServ.getUnique();
            bom.addNewerDependency(archive.getCoordinate());
        }
    }
}

