/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.quickfix;

import org.apache.commons.lang.StringUtils;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.QuickfixModel;
import org.jboss.windup.reporting.model.QuickfixType;
import org.jboss.windup.reporting.model.ReplacementQuickfixModel;
import org.jboss.windup.reporting.model.TransformationQuickfixModel;
import org.jboss.windup.reporting.service.QuickfixService;
import org.jboss.windup.util.exception.WindupException;

public class Quickfix {
    private QuickfixType type;
    private String name;
    private String newline;
    private String replacementStr;
    private String searchStr;
    private String transformationID;
    private FileModel fileModel;

    public QuickfixType getType() {
        return this.type;
    }

    public void setType(QuickfixType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNewline() {
        return this.newline;
    }

    public void setNewline(String newline) {
        this.newline = newline;
    }

    public String getReplacementStr() {
        return this.replacementStr;
    }

    public void setReplacementStr(String replacementStr) {
        this.replacementStr = replacementStr;
    }

    public String getSearchStr() {
        return this.searchStr;
    }

    public void setSearchStr(String searchStr) {
        this.searchStr = searchStr;
    }

    public FileModel getFileModel() {
        return this.fileModel;
    }

    public void setFileModel(FileModel fileModel) {
        this.fileModel = fileModel;
    }

    public String getTransformationID() {
        return this.transformationID;
    }

    public void setTransformationID(String transformationID) {
        this.transformationID = transformationID;
    }

    public QuickfixModel createQuickfix(GraphContext graphContext) {
        QuickfixService quickfixService = new QuickfixService(graphContext);
        QuickfixModel quickfixModel = (QuickfixModel)quickfixService.create();
        quickfixModel.setQuickfixType(this.getType());
        quickfixModel.setName(StringUtils.trim((String)this.getName()));
        switch (this.getType()) {
            case INSERT_LINE: 
            case DELETE_LINE: 
            case REPLACE: 
            case REGULAR_EXPRESSION: {
                ReplacementQuickfixModel replacementQuickfixModel = (ReplacementQuickfixModel)GraphService.addTypeToModel((GraphContext)graphContext, (WindupVertexFrame)quickfixModel, ReplacementQuickfixModel.class);
                replacementQuickfixModel.setReplacement(StringUtils.trim((String)this.getReplacementStr()));
                replacementQuickfixModel.setSearch(StringUtils.trim((String)this.getSearchStr()));
                replacementQuickfixModel.setNewline(StringUtils.trim((String)this.getNewline()));
                break;
            }
            case TRANSFORMATION: {
                TransformationQuickfixModel transformationQuickfixModel = (TransformationQuickfixModel)GraphService.addTypeToModel((GraphContext)graphContext, (WindupVertexFrame)quickfixModel, TransformationQuickfixModel.class);
                transformationQuickfixModel.setTransformationID(this.getTransformationID());
                transformationQuickfixModel.setFileModel(this.getFileModel());
                break;
            }
            default: {
                throw new WindupException("Unrecognized quickfix type: " + (Object)((Object)this.getType()));
            }
        }
        return quickfixModel;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder((Object)((Object)this.type) + " Name: " + this.getName());
        if (this.type == QuickfixType.INSERT_LINE) {
            sb.append(" newline: " + this.getNewline());
        }
        if (this.type == QuickfixType.REPLACE) {
            sb.append(" search: " + this.getSearchStr());
            sb.append(" replacement: " + this.getReplacementStr());
        }
        return sb.toString();
    }
}

