/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.model.TechnologyTagModel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.javaee.model.EnvironmentReferenceModel;
import org.jboss.windup.rules.apps.javaee.model.EnvironmentReferenceTagType;
import org.jboss.windup.rules.apps.javaee.model.WebXmlModel;
import org.jboss.windup.rules.apps.javaee.service.EnvironmentReferenceService;
import org.jboss.windup.rules.apps.javaee.service.WebXmlService;
import org.jboss.windup.rules.apps.xml.model.DoctypeMetaModel;
import org.jboss.windup.rules.apps.xml.model.NamespaceMetaModel;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.service.XmlFileService;
import org.jboss.windup.util.xml.DoctypeUtils;
import org.jboss.windup.util.xml.NamespaceUtils;
import org.joox.JOOX;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@RuleMetadata(phase=InitialAnalysisPhase.class, perform="Discover web.xml files")
public class DiscoverWebXmlRuleProvider
extends IteratingRuleProvider<XmlFileModel> {
    private static final Logger LOG = Logger.getLogger(DiscoverWebXmlRuleProvider.class.getSimpleName());
    private static final String TECH_TAG = "Web XML";
    private static final TechnologyTagLevel TECH_TAG_LEVEL = TechnologyTagLevel.INFORMATIONAL;
    private static final String REGEX_DTD = "(?i).*web.application.*";

    public ConditionBuilder when() {
        return Query.fromType(XmlFileModel.class).withProperty("rootTagName", (Object)"web-app");
    }

    public void perform(GraphRewrite event, EvaluationContext context, XmlFileModel payload) {
        XmlFileService xmlFileService = new XmlFileService(event.getGraphContext());
        Document doc = xmlFileService.loadDocumentQuiet(event, context, payload);
        if (doc != null && this.isWebXml(payload, doc)) {
            this.addWebXmlMetadata(event, context, event.getGraphContext(), payload, doc);
        }
    }

    private boolean isWebXml(XmlFileModel xml, Document doc) {
        return xml.getDoctype() == null || this.processDoctypeMatches(xml.getDoctype());
    }

    private String getVersion(XmlFileModel xml, Document doc) {
        String version;
        block4: {
            block3: {
                version = null;
                if (xml.getDoctype() == null) break block3;
                if (!this.processDoctypeMatches(xml.getDoctype())) break block4;
                version = this.processDoctypeVersion(xml.getDoctype());
                break block4;
            }
            version = JOOX.$((Document)doc).attr("version");
            if (StringUtils.isBlank((CharSequence)version)) {
                String namespace = JOOX.$((Document)doc).find("web-app").namespaceURI();
                if (StringUtils.isBlank((CharSequence)namespace)) {
                    namespace = doc.getFirstChild().getNamespaceURI();
                }
                for (NamespaceMetaModel ns : xml.getNamespaces()) {
                    if (!StringUtils.equals((CharSequence)ns.getURI(), (CharSequence)namespace)) continue;
                    version = NamespaceUtils.extractVersion((String)ns.getSchemaLocation());
                    break;
                }
            }
        }
        return version;
    }

    private void addWebXmlMetadata(GraphRewrite event, EvaluationContext evaluationContext, GraphContext context, XmlFileModel xml, Document doc) {
        ClassificationService classificationService = new ClassificationService(context);
        TechnologyTagService technologyTagService = new TechnologyTagService(context);
        classificationService.attachClassification(event, evaluationContext, (FileModel)xml, TECH_TAG, " Web Application Deployment Descriptors");
        TechnologyTagModel technologyTag = technologyTagService.addTagToFileModel((FileModel)xml, TECH_TAG, TECH_TAG_LEVEL);
        WebXmlService webXmlService = new WebXmlService(context);
        String webXmlVersion = this.getVersion(xml, doc);
        WebXmlModel webXml = (WebXmlModel)webXmlService.addTypeToModel((WindupVertexFrame)xml);
        if (StringUtils.isNotBlank((CharSequence)webXmlVersion)) {
            webXmlVersion = StringUtils.replace((String)webXmlVersion, (String)"_", (String)".");
            webXml.setSpecificationVersion(webXmlVersion);
            technologyTag.setVersion(webXmlVersion);
        }
        String displayName = JOOX.$((Document)doc).child("display-name").text();
        if (StringUtils.isNotBlank((CharSequence)(displayName = StringUtils.trimToNull((String)displayName)))) {
            webXml.setDisplayName(displayName);
        }
        List<EnvironmentReferenceModel> refs = this.processEnvironmentReference(context, doc.getDocumentElement());
        for (EnvironmentReferenceModel ref : refs) {
            webXml.addEnvironmentReference(ref);
        }
    }

    private boolean processDoctypeMatches(DoctypeMetaModel doctypeMetaModel) {
        if (StringUtils.isNotBlank((CharSequence)doctypeMetaModel.getPublicId()) && Pattern.matches(REGEX_DTD, doctypeMetaModel.getPublicId())) {
            return true;
        }
        return StringUtils.isNotBlank((CharSequence)doctypeMetaModel.getSystemId()) && Pattern.matches(REGEX_DTD, doctypeMetaModel.getSystemId());
    }

    private String processDoctypeVersion(DoctypeMetaModel entry) {
        String publicId = entry.getPublicId();
        String systemId = entry.getSystemId();
        String versionInformation = DoctypeUtils.extractVersion((String)publicId, (String)systemId);
        return versionInformation;
    }

    private List<EnvironmentReferenceModel> processEnvironmentReference(GraphContext context, Element element) {
        EnvironmentReferenceService environmentReferenceService = new EnvironmentReferenceService(context);
        ArrayList<EnvironmentReferenceModel> resources = new ArrayList<EnvironmentReferenceModel>();
        for (Element resourceRef : JOOX.$((Element)element).find("resource-ref").get()) {
            this.processElement(environmentReferenceService, resources, resourceRef, "res-type", "res-ref-name", EnvironmentReferenceTagType.RESOURCE_REF);
        }
        for (Element resourceRef : JOOX.$((Element)element).find("ejb-ref").get()) {
            this.processElement(environmentReferenceService, resources, resourceRef, "ejb-ref-type", "ejb-ref-name", EnvironmentReferenceTagType.EJB_REF);
        }
        for (Element resourceRef : JOOX.$((Element)element).find("ejb-local-ref").get()) {
            this.processElement(environmentReferenceService, resources, resourceRef, "ejb-ref-type", "ejb-ref-name", EnvironmentReferenceTagType.EJB_LOCAL_REF);
        }
        for (Element resourceRef : JOOX.$((Element)element).find("message-destination-ref").get()) {
            this.processElement(environmentReferenceService, resources, resourceRef, "message-destination-type", "message-destination-ref-name", EnvironmentReferenceTagType.MSG_DESTINATION_REF);
        }
        return resources;
    }

    private void processElement(EnvironmentReferenceService environmentReferenceService, List<EnvironmentReferenceModel> resources, Element element, String typeLocation, String nameLocation, EnvironmentReferenceTagType refType) {
        String id = JOOX.$((Element)element).attr("id");
        String type = JOOX.$((Element)element).child(typeLocation).text();
        String name = JOOX.$((Element)element).child(nameLocation).text();
        type = StringUtils.trim((String)type);
        EnvironmentReferenceModel ref = environmentReferenceService.findEnvironmentReference(name = StringUtils.trim((String)name), refType);
        if (ref == null) {
            ref = (EnvironmentReferenceModel)environmentReferenceService.create();
            ref.setName(name);
            ref.setReferenceType(type);
            ref.setReferenceTagType(refType);
            LOG.info("Added: " + ref);
        } else if (ref.getReferenceTagType() != null && ref.getReferenceTagType() != refType) {
            LOG.warning("Expected type: " + (Object)((Object)EnvironmentReferenceTagType.RESOURCE_REF) + " but actually: " + ref.getReferenceType());
        }
        ref.setReferenceId(id);
        resources.add(ref);
    }
}

