/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules.jboss;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.projecttraversal.ProjectTraversalCache;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.javaee.model.EjbMessageDrivenModel;
import org.jboss.windup.rules.apps.javaee.model.EjbSessionBeanModel;
import org.jboss.windup.rules.apps.javaee.model.EnvironmentReferenceModel;
import org.jboss.windup.rules.apps.javaee.model.JNDIResourceModel;
import org.jboss.windup.rules.apps.javaee.model.JmsDestinationModel;
import org.jboss.windup.rules.apps.javaee.rules.DiscoverEjbConfigurationXmlRuleProvider;
import org.jboss.windup.rules.apps.javaee.service.EnvironmentReferenceService;
import org.jboss.windup.rules.apps.javaee.service.JNDIResourceService;
import org.jboss.windup.rules.apps.javaee.service.JmsDestinationService;
import org.jboss.windup.rules.apps.javaee.service.VendorSpecificationExtensionService;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.service.XmlFileService;
import org.joox.JOOX;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@RuleMetadata(phase=InitialAnalysisPhase.class, after={DiscoverEjbConfigurationXmlRuleProvider.class}, perform="Discover JBoss EJB XML Files")
public class ResolveJBossLegacyEjbXmlRuleProvider
extends IteratingRuleProvider<XmlFileModel> {
    private static final Logger LOG = Logger.getLogger(ResolveJBossLegacyEjbXmlRuleProvider.class.getSimpleName());

    public ConditionBuilder when() {
        return Query.fromType(XmlFileModel.class).withProperty("rootTagName", (Object)"jboss").withProperty("fileName", (Object)"jboss.xml");
    }

    public void perform(GraphRewrite event, EvaluationContext context, XmlFileModel payload) {
        String ejbName;
        XmlFileService xmlFileService = new XmlFileService(event.getGraphContext());
        Document doc = xmlFileService.loadDocumentQuiet(event, context, payload);
        if (JOOX.$((Document)doc).find("enterprise-beans").isEmpty()) {
            LOG.warning("Expected enterprise-beans tag. Ignoring: " + payload.getFileName());
            return;
        }
        EnvironmentReferenceService envRefService = new EnvironmentReferenceService(event.getGraphContext());
        JNDIResourceService jndiResourceService = new JNDIResourceService(event.getGraphContext());
        JmsDestinationService jmsDestinationService = new JmsDestinationService(event.getGraphContext());
        GraphService ejbSessionBeanService = new GraphService(event.getGraphContext(), EjbSessionBeanModel.class);
        GraphService mdbService = new GraphService(event.getGraphContext(), EjbMessageDrivenModel.class);
        VendorSpecificationExtensionService vendorSpecificationService = new VendorSpecificationExtensionService(event.getGraphContext());
        vendorSpecificationService.associateAsVendorExtension((FileModel)payload, "ejb-jar.xml");
        TechnologyTagService technologyTagService = new TechnologyTagService(event.getGraphContext());
        technologyTagService.addTagToFileModel((FileModel)payload, "JBoss EJB XML", TechnologyTagLevel.IMPORTANT);
        Set applications = ProjectTraversalCache.getApplicationsForProject((GraphContext)event.getGraphContext(), (ProjectModel)payload.getProjectModel());
        HashMap<String, String> resourceManagerReferences = new HashMap<String, String>();
        for (Element resourceRef : JOOX.$((Document)doc).find("resource-managers").children("resource-manager").get()) {
            String resourceName = JOOX.$((Element)resourceRef).child("res-name").text();
            String resourceJNDI = JOOX.$((Element)resourceRef).child("res-jndi-name").text();
            resourceManagerReferences.put(resourceName, resourceJNDI);
            LOG.info("Found Resource Manager: " + resourceName + ", " + resourceJNDI);
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("resource-ref").get()) {
            this.processBinding(envRefService, jndiResourceService, applications, resourceManagerReferences, resourceRef, "res-ref-name", "jndi-name");
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("resource-env-ref").get()) {
            this.processBinding(envRefService, jndiResourceService, applications, resourceManagerReferences, resourceRef, "resource-env-ref-name", "jndi-name");
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("message-destination-ref").get()) {
            this.processBinding(envRefService, jndiResourceService, applications, resourceManagerReferences, resourceRef, "message-destination-ref-name", "jndi-name");
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("ejb-ref").get()) {
            this.processBinding(envRefService, jndiResourceService, applications, resourceManagerReferences, resourceRef, "ejb-ref-name", "jndi-name");
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("ejb-local-ref").get()) {
            this.processBinding(envRefService, jndiResourceService, applications, resourceManagerReferences, resourceRef, "ejb-ref-name", "local-jndi-name");
        }
        for (Element ejbRef : JOOX.$((Document)doc).find("session").get()) {
            ejbName = JOOX.$((Element)ejbRef).child("ejb-name").content();
            String sessionClustered = JOOX.$((Element)ejbRef).child("clustered").content();
            sessionClustered = StringUtils.trim((String)sessionClustered);
            Map<String, Integer> txTimeouts = this.parseTxTimeout(ejbRef, ejbName);
            if (!StringUtils.isNotBlank((CharSequence)ejbName)) continue;
            LOG.info("Looking up name: " + ejbName);
            for (EjbSessionBeanModel ejb : ejbSessionBeanService.findAllByProperty("ejbBeanName", (Object)ejbName)) {
                JNDIResourceModel jndiRef;
                String jndi = JOOX.$((Element)ejbRef).child("jndi-name").content();
                String localJNDI = JOOX.$((Element)ejbRef).child("local-jndi-name").content();
                if (StringUtils.isNotBlank((CharSequence)jndi)) {
                    jndiRef = jndiResourceService.createUnique(applications, jndi);
                    ejb.setGlobalJndiReference(jndiRef);
                }
                if (StringUtils.isNotBlank((CharSequence)localJNDI)) {
                    jndiRef = jndiResourceService.createUnique(applications, localJNDI);
                    ejb.setLocalJndiReference(jndiRef);
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)sessionClustered)) {
                    ejb.setClustered(true);
                }
                ejb.setTxTimeouts(txTimeouts);
            }
        }
        for (Element messageDrivenRef : JOOX.$((Document)doc).find("message-driven").get()) {
            ejbName = JOOX.$((Element)messageDrivenRef).child("ejb-name").text();
            Map<String, Integer> txTimeouts = this.parseTxTimeout(messageDrivenRef, ejbName);
            LOG.info("Found MDB: " + ejbName);
            if (!StringUtils.isNotBlank((CharSequence)ejbName)) continue;
            for (EjbMessageDrivenModel mdb : mdbService.findAllByProperty("ejbBeanName", (Object)ejbName)) {
                String destination = JOOX.$((Element)messageDrivenRef).child("destination-jndi-name").text();
                if (StringUtils.isNotBlank((CharSequence)destination)) {
                    JmsDestinationModel jndiRef = jmsDestinationService.createUnique(applications, destination);
                    mdb.setDestination(jndiRef);
                }
                mdb.setTxTimeouts(txTimeouts);
            }
        }
    }

    private Map<String, Integer> parseTxTimeout(Element elementRef, String ejbName) {
        HashMap<String, Integer> transactionTimeouts = new HashMap<String, Integer>();
        for (Element methodRef : JOOX.$((Element)elementRef).child("method-attributes").find("method").get()) {
            String methodName = JOOX.$((Element)methodRef).child("method-name").content();
            String transactionTimeout = JOOX.$((Element)methodRef).child("transaction-timeout").content();
            if (!StringUtils.isNotBlank((CharSequence)transactionTimeout)) continue;
            try {
                Integer txTimeout = Integer.parseInt(transactionTimeout);
                transactionTimeouts.put(methodName, txTimeout);
            }
            catch (Exception e) {
                LOG.info("EJB: " + ejbName + " contains bad reference to TX Timeout on Method: " + methodName);
            }
        }
        return transactionTimeouts;
    }

    private void processBinding(EnvironmentReferenceService envRefService, JNDIResourceService jndiResourceService, Set<ProjectModel> applications, Map<String, String> resourceManagerReferences, Element resourceRef, String tagName, String tagJndi) {
        String jndiLocation = JOOX.$((Element)resourceRef).child(tagJndi).text();
        String resourceRefName = JOOX.$((Element)resourceRef).child(tagName).text();
        String resourceName = JOOX.$((Element)resourceRef).child("resource-name").text();
        LOG.info("Processing binding: " + JOOX.$((Element)resourceRef).toString());
        LOG.info("JNDI Name: " + jndiLocation + " to Resource: " + resourceRefName);
        if (StringUtils.isBlank((CharSequence)jndiLocation) && StringUtils.isNotBlank((CharSequence)resourceName)) {
            jndiLocation = resourceManagerReferences.get(resourceName);
        }
        if (StringUtils.isNotBlank((CharSequence)jndiLocation) && StringUtils.isNotBlank((CharSequence)resourceRefName)) {
            JNDIResourceModel resource = jndiResourceService.createUnique(applications, jndiLocation);
            LOG.info("JNDI Name: " + jndiLocation + " to Resource: " + resourceRefName);
            for (EnvironmentReferenceModel ref : envRefService.findAllByProperty("name", resourceRefName)) {
                envRefService.associateEnvironmentToJndi(resource, ref);
            }
        }
    }
}

