/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.engine.predicates;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.RuleProvider;

public class RuleProviderWithDependenciesPredicate
implements Predicate<RuleProvider> {
    private static final Logger LOG = Logger.getLogger(RuleProviderWithDependenciesPredicate.class.getName());
    private final List<RuleProvider> ruleProviders = new ArrayList<RuleProvider>();

    @SafeVarargs
    public RuleProviderWithDependenciesPredicate(Class<? extends RuleProvider> provider, Class<? extends RuleProvider> ... providers) throws InstantiationException, IllegalAccessException {
        this.ruleProviders.add(provider.newInstance());
        for (Class<? extends RuleProvider> clazz : providers) {
            this.ruleProviders.add(clazz.newInstance());
        }
    }

    public boolean accept(RuleProvider provider) {
        if (!(provider instanceof AbstractRuleProvider)) {
            return false;
        }
        int examinedProviderExecutionIndex = ((AbstractRuleProvider)provider).getExecutionIndex();
        for (RuleProvider currentRuleProvider : this.ruleProviders) {
            int otherExecutionIndex = ((AbstractRuleProvider)currentRuleProvider).getExecutionIndex();
            if (otherExecutionIndex <= examinedProviderExecutionIndex) {
                LOG.fine("Accepting provider '" + provider.getMetadata().getID() + "' because it's before: " + currentRuleProvider.getMetadata().getID());
                return true;
            }
            List executeAfter = currentRuleProvider.getMetadata().getExecuteAfter();
            List executeAfterIDs = currentRuleProvider.getMetadata().getExecuteAfterIDs();
            if (executeAfter.contains(provider.getClass()) || executeAfterIDs.contains(provider.getMetadata().getID())) {
                LOG.fine("Accepting provider: " + provider.getMetadata().getID());
                return true;
            }
            for (Class afterType : executeAfter) {
                if (!afterType.isAssignableFrom(provider.getClass())) continue;
                LOG.fine("Accepting provider: " + provider.getMetadata().getID());
                return true;
            }
            if (!currentRuleProvider.getClass().isAssignableFrom(provider.getClass())) continue;
            LOG.fine("Accepting provider: " + provider.getMetadata().getID());
            return true;
        }
        LOG.fine("Skipping provider: " + provider.getMetadata().getID());
        return false;
    }
}

