/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.projects;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.forge.addon.environment.Environment;
import org.jboss.forge.addon.maven.environment.Network;
import org.jboss.forge.addon.maven.projects.MavenFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.building.BuildException;
import org.jboss.forge.addon.projects.building.ProjectBuilder;
import org.jboss.forge.addon.projects.facets.PackagingFacet;
import org.jboss.forge.addon.resource.Resource;

public class MavenProjectBuilder
implements ProjectBuilder {
    private final Environment environment;
    private final Project project;
    private boolean runTests = true;
    private boolean quiet;
    private final List<String> profiles = new ArrayList<String>();
    private final List<String> args = new ArrayList<String>();

    public MavenProjectBuilder(Environment environment, Project project) {
        this.environment = environment;
        this.project = project;
    }

    public ProjectBuilder addArguments(String ... args) {
        this.args.addAll(Arrays.asList(args));
        return this;
    }

    public ProjectBuilder runTests(boolean test) {
        this.runTests = test;
        return this;
    }

    public ProjectBuilder quiet(boolean quiet) {
        this.quiet = quiet;
        return this;
    }

    public ProjectBuilder profiles(String ... profiles) {
        this.profiles.clear();
        this.profiles.addAll(Arrays.asList(profiles));
        return this;
    }

    public Resource<?> build() {
        return this.build(System.out, System.err);
    }

    public Resource<?> build(PrintStream out, PrintStream err) throws BuildException {
        boolean success;
        ArrayList<String> selected = new ArrayList<String>();
        if (this.args != null && !this.args.isEmpty()) {
            selected.addAll(this.args);
        } else {
            selected.add("clean");
            selected.add("install");
        }
        if (Network.isOffline((Environment)this.environment)) {
            selected.add("--offline");
        }
        if (!this.runTests) {
            selected.add("-DskipTests=true");
            selected.add("-Dmaven.test.skip=true");
        }
        if (this.quiet) {
            selected.add("-q");
        }
        if (this.profiles.size() > 0) {
            selected.add("-P" + String.join((CharSequence)",", this.profiles));
        }
        if (success = ((MavenFacet)this.project.getFacet(MavenFacet.class)).executeMavenEmbedded(selected, out, err)) {
            return ((PackagingFacet)this.project.getFacet(PackagingFacet.class)).getFinalArtifact();
        }
        throw new BuildException("Build failed.");
    }
}

