/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.xml;

import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.exception.ConfigurationException;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.reporting.config.Link;
import org.jboss.windup.util.exception.WindupException;
import org.joox.JOOX;
import org.w3c.dom.Element;

@NamespaceElementHandler(elementName="link", namespace="http://windup.jboss.org/schema/jboss-ruleset")
public class LinkHandler
implements ElementHandler<Link> {
    static final String ELEMENT_NAME = "link";
    private static final String HREF_ATTR = "href";
    private static final String TITLE_ATTR = "title";

    public Link processElement(ParserContext handlerManager, Element element) throws ConfigurationException {
        String link = JOOX.$((Element)element).attr(HREF_ATTR);
        if (StringUtils.isBlank((CharSequence)link)) {
            throw new WindupException("Error, 'link' element must have a non-empty 'href' attribute (eg, 'http://www.example.com/somepage.html')");
        }
        String title = JOOX.$((Element)element).attr(TITLE_ATTR);
        if (StringUtils.isBlank((CharSequence)title)) {
            throw new WindupException("Error, 'link' element must have a non-empty 'title' attribute (eg, 'Documentation for XYZ')");
        }
        return Link.to((String)title, (String)link);
    }
}

