/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.core.NestableArchive;
import org.jboss.tattletale.reporting.CLSReport;
import org.jboss.tattletale.reporting.Dump;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependantsReport
extends CLSReport {
    private static final String NAME = "Dependants";
    private static final String DIRECTORY = "dependants";

    public DependantsReport() {
        super(DIRECTORY, 0, NAME, DIRECTORY);
    }

    @Override
    public void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.newLine());
        bw.write("  <tr>" + Dump.newLine());
        bw.write("     <th>Archive</th>" + Dump.newLine());
        bw.write("     <th>Dependants</th>" + Dump.newLine());
        boolean odd = true;
        for (Archive archive : this.archives) {
            String archiveName = archive.getName();
            int finalDot = archiveName.lastIndexOf(".");
            String extension = archiveName.substring(finalDot + 1);
            if (odd) {
                bw.write("  <tr class=\"rowodd\">" + Dump.newLine());
            } else {
                bw.write("  <tr class=\"roweven\">" + Dump.newLine());
            }
            bw.write("     <td><a href=\"../" + extension + "/" + archiveName + ".html\">" + archiveName + "</a></td>" + Dump.newLine());
            bw.write("     <td>");
            TreeSet<String> result = new TreeSet<String>();
            for (Archive a : this.archives) {
                for (String require : this.getRequires(archive)) {
                    if (!archive.doesProvide(require) || this.getCLS() != null && !this.getCLS().isVisible(a, archive)) continue;
                    result.add(a.getName());
                }
            }
            if (result.size() == 0) {
                bw.write("&nbsp;");
            } else {
                Iterator resultIt = result.iterator();
                while (resultIt.hasNext()) {
                    String r = (String)resultIt.next();
                    if (r.endsWith(".jar")) {
                        bw.write("<a href=\"../jar/" + r + ".html\">" + r + "</a>");
                    } else {
                        bw.write("<i>" + r + "</i>");
                    }
                    if (!resultIt.hasNext()) continue;
                    bw.write(", ");
                }
            }
            bw.write("</td>" + Dump.newLine());
            bw.write("  </tr>" + Dump.newLine());
            odd = !odd;
        }
        bw.write("  </tr>" + Dump.newLine());
        bw.write("</table>" + Dump.newLine());
    }

    private SortedSet<String> getRequires(Archive archive) {
        TreeSet<String> requires = new TreeSet<String>();
        if (archive instanceof NestableArchive) {
            NestableArchive nestableArchive = (NestableArchive)archive;
            List<Archive> subArchives = nestableArchive.getSubArchives();
            requires.addAll(nestableArchive.getRequires());
            for (Archive sa : subArchives) {
                requires.addAll(this.getRequires(sa));
            }
        } else {
            requires.addAll(archive.getRequires());
        }
        return requires;
    }

    @Override
    public void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.newLine());
        bw.write(Dump.newLine());
        bw.write("<h1>Dependants</h1>" + Dump.newLine());
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.newLine());
        bw.write("<p>" + Dump.newLine());
    }
}

