/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.util.furnace;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.DirectoryWalker;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.util.AddonFilters;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.windup.util.PathUtil;
import org.jboss.windup.util.furnace.FileExtensionFilter;

public class FurnaceClasspathScanner {
    private static final Logger LOG = Logger.getLogger(FurnaceClasspathScanner.class.getName());
    private final Furnace furnace = SimpleContainer.getFurnace((ClassLoader)FurnaceClasspathScanner.class.getClassLoader());

    public List<URL> scan(String fileExtension) {
        return this.scan(new FileExtensionFilter(fileExtension));
    }

    public Map<Addon, List<URL>> scanForAddonMap(Predicate<String> filter) {
        IdentityHashMap<Addon, List<URL>> result = new IdentityHashMap<Addon, List<URL>>();
        for (Addon addon : this.furnace.getAddonRegistry(new AddonRepository[0]).getAddons(AddonFilters.allStarted())) {
            List<String> filteredResourcePaths = this.filterAddonResources(addon, filter);
            ArrayList<URL> discoveredURLs = new ArrayList<URL>();
            for (String filePath : filteredResourcePaths) {
                URL ruleFile = addon.getClassLoader().getResource(filePath);
                if (ruleFile == null) continue;
                discoveredURLs.add(ruleFile);
            }
            result.put(addon, discoveredURLs);
        }
        return result;
    }

    public List<URL> scan(Predicate<String> filter) {
        ArrayList<URL> discoveredURLs = new ArrayList<URL>(128);
        for (Addon addon : this.furnace.getAddonRegistry(new AddonRepository[0]).getAddons(AddonFilters.allStarted())) {
            List<String> filteredResourcePaths = this.filterAddonResources(addon, filter);
            for (String filePath : filteredResourcePaths) {
                URL ruleFile = addon.getClassLoader().getResource(filePath);
                if (ruleFile == null) continue;
                discoveredURLs.add(ruleFile);
            }
        }
        return discoveredURLs;
    }

    public List<Class<?>> scanClasses(Predicate<String> filter) {
        ArrayList discoveredClasses = new ArrayList(128);
        for (Addon addon : this.furnace.getAddonRegistry(new AddonRepository[0]).getAddons(AddonFilters.allStarted())) {
            List<String> discoveredFileNames = this.filterAddonResources(addon, filter);
            for (String discoveredFilename : discoveredFileNames) {
                String clsName = PathUtil.classFilePathToClassname(discoveredFilename);
                try {
                    Class<?> clazz = addon.getClassLoader().loadClass(clsName);
                    discoveredClasses.add(clazz);
                }
                catch (ClassNotFoundException ex) {
                    LOG.log(Level.WARNING, "Failed to load class for name '" + clsName + "':\n" + ex.getMessage(), ex);
                }
            }
        }
        return discoveredClasses;
    }

    public List<String> filterAddonResources(Addon addon, Predicate<String> filter) {
        ArrayList<String> discoveredFileNames = new ArrayList<String>();
        List addonResources = addon.getRepository().getAddonResources(addon.getId());
        for (File addonFile : addonResources) {
            if (addonFile.isDirectory()) {
                this.handleDirectory(filter, addonFile, discoveredFileNames);
                continue;
            }
            this.handleArchiveByFile(filter, addonFile, discoveredFileNames);
        }
        return discoveredFileNames;
    }

    private void handleArchiveByFile(Predicate<String> filter, File archive, List<String> discoveredFiles) {
        try (ZipFile zip = new ZipFile(archive);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!filter.accept((Object)name)) continue;
                discoveredFiles.add(name);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error handling file " + archive, e);
        }
    }

    private void handleDirectory(final Predicate<String> filter, final File rootDir, final List<String> discoveredFiles) {
        try {
            new DirectoryWalker<String>(){
                private Path startDir;

                public void walk() throws IOException {
                    this.startDir = rootDir.toPath();
                    this.walk(rootDir, discoveredFiles);
                }

                protected void handleFile(File file, int depth, Collection<String> discoveredFiles2) throws IOException {
                    String newPath = this.startDir.relativize(file.toPath()).toString();
                    if (filter.accept((Object)newPath)) {
                        discoveredFiles2.add(newPath);
                    }
                }
            }.walk();
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, "Error reading Furnace addon directory", ex);
        }
    }
}

