/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.sesametools;

import java.util.Comparator;
import net.fortytwo.sesametools.ValueComparator;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;

public class StatementComparator
implements Comparator<Statement> {
    private static final StatementComparator INSTANCE = new StatementComparator();
    public static final int BEFORE = -1;
    public static final int EQUALS = 0;
    public static final int AFTER = 1;

    public static final StatementComparator getInstance() {
        return INSTANCE;
    }

    @Override
    public int compare(Statement first, Statement second) {
        if (first == second) {
            return 0;
        }
        if (first.getSubject().equals(second.getSubject())) {
            if (first.getPredicate().equals(second.getPredicate())) {
                if (first.getObject().equals(second.getObject())) {
                    if (first.getContext() == null) {
                        if (second.getContext() == null) {
                            return 0;
                        }
                        return -1;
                    }
                    if (second.getContext() == null) {
                        return 1;
                    }
                    return ValueComparator.getInstance().compare((Value)first.getContext(), (Value)second.getContext());
                }
                return ValueComparator.getInstance().compare(first.getObject(), second.getObject());
            }
            return ValueComparator.getInstance().compare((Value)first.getPredicate(), (Value)second.getPredicate());
        }
        return ValueComparator.getInstance().compare((Value)first.getSubject(), (Value)second.getSubject());
    }
}

