/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph;

import com.tinkerpop.blueprints.Element;
import com.tinkerpop.frames.ClassUtilities;
import com.tinkerpop.frames.FramedGraph;
import com.tinkerpop.frames.modules.MethodHandler;
import java.lang.reflect.Method;
import org.jboss.windup.graph.Property;

public class WindupPropertyMethodHandler
implements MethodHandler<Property> {
    public Class<Property> getAnnotationType() {
        return Property.class;
    }

    public Object processElement(Object frame, Method method, Object[] arguments, Property annotation, FramedGraph<?> framedGraph, Element element) {
        if (ClassUtilities.isGetMethod((Method)method)) {
            Object value = element.getProperty(annotation.value());
            if (method.getReturnType().isEnum()) {
                return this.getValueAsEnum(method, value);
            }
            return value;
        }
        if (ClassUtilities.isSetMethod((Method)method)) {
            Object value = arguments[0];
            if (null == value) {
                element.removeProperty(annotation.value());
            } else if (value.getClass().isEnum()) {
                element.setProperty(annotation.value(), (Object)((Enum)value).name());
            } else {
                element.setProperty(annotation.value(), value);
            }
            return frame;
        }
        if (ClassUtilities.isRemoveMethod((Method)method)) {
            element.removeProperty(annotation.value());
            return frame;
        }
        return frame;
    }

    private Enum<?> getValueAsEnum(Method method, Object value) {
        Class<?> returnType = method.getReturnType();
        if (Enum.class.isAssignableFrom(returnType)) {
            Class<?> en = returnType;
            if (value != null) {
                return Enum.valueOf(en, value.toString());
            }
        }
        throw new IllegalArgumentException("Method does not return an Enum type.");
    }
}

