/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.configuration.ui;

import java.io.PrintStream;
import java.util.Iterator;
import javax.inject.Inject;
import org.jboss.forge.addon.configuration.Configuration;
import org.jboss.forge.addon.configuration.facets.ConfigurationFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.Projects;
import org.jboss.forge.addon.shell.Shell;
import org.jboss.forge.addon.shell.ui.AbstractShellCommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class ConfigListCommand
extends AbstractShellCommand {
    @Inject
    private Configuration userConfig;
    @Inject
    private ProjectFactory projectFactory;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).category(Categories.create((String[])new String[]{"Configuration"})).name("Config: List");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Shell shell = (Shell)context.getUIContext().getProvider();
        PrintStream out = shell.getOutput().out();
        Project project = Projects.getSelectedProject((ProjectFactory)this.projectFactory, (UIContext)context.getUIContext());
        Configuration projectConfig = null;
        if (project != null) {
            projectConfig = ((ConfigurationFacet)project.getFacet(ConfigurationFacet.class)).getConfiguration();
        }
        Iterator userConfigKeys = this.userConfig.getKeys();
        while (userConfigKeys.hasNext()) {
            Object key = userConfigKeys.next();
            if (key != null) {
                out.print(key.toString());
                out.print("=");
                out.print("user: [" + this.userConfig.getProperty(key.toString()) + "]");
                if (projectConfig != null) {
                    out.print(", project: ");
                    Object value = projectConfig.getProperty(key.toString());
                    if (value != null) {
                        out.print("[" + value.toString() + "] ");
                    } else {
                        out.print("[]");
                    }
                }
            }
            out.println();
        }
        if (projectConfig != null) {
            Iterator projectConfigKeys = projectConfig.getKeys();
            while (projectConfigKeys.hasNext()) {
                String key = projectConfigKeys.next().toString();
                if (this.userConfig.containsKey(key)) continue;
                out.print(key.toString());
                out.print("=project: [");
                out.print(projectConfig.getProperty(key.toString()).toString() + "]");
            }
        }
        return Results.success();
    }
}

