/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.ui;

import java.io.File;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.progress.UIProgressMonitor;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;
import org.jboss.windup.engine.WindupConfiguration;
import org.jboss.windup.engine.WindupProcessor;
import org.jboss.windup.engine.WindupProgressMonitor;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.GraphContextFactory;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.ui.WindupProgressMonitorAdapter;

public class WindupWizard
implements UIWizard,
UICommand {
    @Inject
    private WindupProcessor processor;
    @Inject
    private GraphContextFactory factory;
    @Inject
    @WithAttributes(label="Input", required=true, description="Input File or Directory (a Directory is required for source mode)")
    private UIInput<FileResource<?>> input;
    @Inject
    @WithAttributes(label="Output", required=true, description="Output Directory (WARNING: any existing files will be removed)")
    private UIInput<DirectoryResource> output;
    @Inject
    @WithAttributes(label="Scan Java Packages", required=false, description="A list of java package name prefixes to scan (eg, com.myapp)")
    private UIInputMany<String> packages;
    @Inject
    @WithAttributes(label="Exclude Java Packages", required=false, description="A list of java package name prefixes to exclude (eg, com.myapp.subpackage)")
    private UIInputMany<String> excludePackages;
    @Inject
    @WithAttributes(label="Fetch Remote Resources", required=false, defaultValue="true", description="Indicates whether to fetch maven information from the internet (default: true)")
    private UIInput<Boolean> fetchRemote;
    @Inject
    @WithAttributes(label="Source Mode", required=false, defaultValue="false", description="Indicates whether the input file or directory is a source code or compiled binaries (Default: Compiled)")
    private UIInput<Boolean> sourceMode;
    @Inject
    @WithAttributes(label="Overwrite", required=false, defaultValue="false", description="Force overwrite of the output directory, without prompting")
    private UIInput<Boolean> overwrite;
    @Inject
    @WithAttributes(label="User Rules Directory", required=false, description="User Rules Directory (Search pattern: *.windup.groovy)")
    private UIInput<DirectoryResource> userRulesDirectory;

    public UICommandMetadata getMetadata(UIContext ctx) {
        return Metadata.forCommand(this.getClass()).name("Windup Migrate App").description("Run Windup Migration Analyzer").category(Categories.create((String[])new String[]{"Platform", "Migration"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.input).add(this.output).add(this.packages).add(this.excludePackages).add(this.fetchRemote).add(this.sourceMode).add(this.overwrite).add(this.userRulesDirectory);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        File inputFile = (File)((FileResource)this.input.getValue()).getUnderlyingResourceObject();
        File outputFile = (File)((DirectoryResource)this.output.getValue()).getUnderlyingResourceObject();
        FileResource userRulesInputValue = (FileResource)this.userRulesDirectory.getValue();
        File userRulesDirectory = userRulesInputValue != null ? (File)userRulesInputValue.getUnderlyingResourceObject() : null;
        List scanJavaPackages = (List)this.packages.getValue();
        List excludeJavaPackages = (List)this.excludePackages.getValue();
        boolean fetchRemote = (Boolean)this.fetchRemote.getValue();
        boolean sourceMode = (Boolean)this.sourceMode.getValue();
        boolean overwrite = (Boolean)this.overwrite.getValue();
        if (!overwrite && this.pathNotEmpty(outputFile)) {
            String promptMsg = "Overwrite all contents of \"" + outputFile.toString() + "\" (anything already in the directory will be deleted)?";
            if (!context.getPrompt().promptBoolean(promptMsg)) {
                return Results.fail((String)"Windup execution aborted!");
            }
        }
        FileUtils.deleteDirectory((File)outputFile);
        try (GraphContext graphContext = this.factory.create(outputFile.toPath().resolve("graph"));){
            WindupConfigurationModel cfg = WindupConfigurationService.getConfigurationModel((GraphContext)graphContext);
            cfg.setInputPath(inputFile.getAbsolutePath());
            cfg.setOutputPath(outputFile.getAbsolutePath());
            cfg.setFetchRemoteResources(fetchRemote);
            cfg.setSourceMode(sourceMode);
            cfg.setScanJavaPackageList((Iterable)scanJavaPackages);
            cfg.setExcludeJavaPackageList((Iterable)excludeJavaPackages);
            if (userRulesDirectory != null) {
                cfg.setUserRulesPath(userRulesDirectory.getAbsolutePath());
            }
            UIProgressMonitor uiProgressMonitor = context.getProgressMonitor();
            WindupProgressMonitorAdapter progressMonitor = new WindupProgressMonitorAdapter(uiProgressMonitor);
            WindupConfiguration wpConf = new WindupConfiguration().setProgressMonitor((WindupProgressMonitor)progressMonitor).setGraphContext(graphContext);
            this.processor.execute(wpConf);
            uiProgressMonitor.done();
            Result result = Results.success((String)"Windup execution successful!");
            return result;
        }
    }

    private boolean pathNotEmpty(File f) {
        if (f.exists() && !f.isDirectory()) {
            return true;
        }
        return f.isDirectory() && f.listFiles() != null && f.listFiles().length > 0;
    }

    public void validate(UIValidationContext context) {
        FileResource userRulesInputValue;
        File inputFile;
        FileResource inputValue = (FileResource)this.input.getValue();
        if (!(inputValue == null || (inputFile = (File)inputValue.getUnderlyingResourceObject()) != null && inputFile.exists())) {
            context.addValidationError(this.input, "Input path does not exist");
        }
        if ((userRulesInputValue = (FileResource)this.userRulesDirectory.getValue()) != null && !((File)userRulesInputValue.getUnderlyingResourceObject()).isDirectory()) {
            context.addValidationError(this.userRulesDirectory, "User Rules Directory must exist");
        }
    }

    public boolean isEnabled(UIContext context) {
        return true;
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        return null;
    }
}

