/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.exec;

import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.RuleLifecycleListener;
import org.jboss.windup.engine.WindupProgressMonitor;
import org.jboss.windup.exec.RuleUtils;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.EvaluationContext;

class DefaultRuleLifecycleListener
implements RuleLifecycleListener {
    private final WindupProgressMonitor progressMonitor;
    private final Configuration configuration;

    public DefaultRuleLifecycleListener(WindupProgressMonitor progressMonitor, Configuration configuration) {
        this.progressMonitor = progressMonitor;
        this.configuration = configuration;
    }

    public void beforeExecution() {
        this.progressMonitor.beginTask("Executing Rules: ", this.configuration.getRules().size());
    }

    public void beforeRuleEvaluation(Rule rule, EvaluationContext context) {
        this.progressMonitor.subTask(RuleUtils.prettyPrintRule(rule));
    }

    public void afterRuleConditionEvaluation(GraphRewrite event, EvaluationContext context, Rule rule, boolean result) {
        if (!result) {
            this.progressMonitor.worked(1);
        }
    }

    public void beforeRuleOperationsPerformed(GraphRewrite event, EvaluationContext context, Rule rule) {
    }

    public void afterRuleOperationsPerformed(GraphRewrite event, EvaluationContext context, Rule rule) {
        this.progressMonitor.worked(1);
    }

    public void afterExecution() {
        this.progressMonitor.done();
    }
}

