/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.IteratingRuleProvider;
import org.jboss.windup.config.RulePhase;
import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.service.JavaClassService;
import org.jboss.windup.rules.apps.javaee.model.EjbDeploymentDescriptorModel;
import org.jboss.windup.rules.apps.javaee.model.EjbEntityBeanModel;
import org.jboss.windup.rules.apps.javaee.model.EjbMessageDrivenModel;
import org.jboss.windup.rules.apps.javaee.model.EjbSessionBeanModel;
import org.jboss.windup.rules.apps.javaee.model.EnvironmentReferenceModel;
import org.jboss.windup.rules.apps.javaee.service.EnvironmentReferenceService;
import org.jboss.windup.rules.apps.xml.DiscoverXmlFilesRuleProvider;
import org.jboss.windup.rules.apps.xml.model.DoctypeMetaModel;
import org.jboss.windup.rules.apps.xml.model.NamespaceMetaModel;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.service.XmlFileService;
import org.jboss.windup.util.xml.DoctypeUtils;
import org.jboss.windup.util.xml.NamespaceUtils;
import org.joox.JOOX;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DiscoverEjbConfigurationXmlRuleProvider
extends IteratingRuleProvider<XmlFileModel> {
    private static final String TECH_TAG = "EJB XML";
    private static final TechnologyTagLevel TECH_TAG_LEVEL = TechnologyTagLevel.IMPORTANT;
    private static final String dtdRegex = "(?i).*enterprise.javabeans.*";

    public RulePhase getPhase() {
        return RulePhase.DISCOVERY;
    }

    public List<Class<? extends WindupRuleProvider>> getExecuteAfter() {
        return this.asClassList(new Class[]{DiscoverXmlFilesRuleProvider.class});
    }

    public ConditionBuilder when() {
        return Query.find(XmlFileModel.class).withProperty("rootTagName", (Object)"ejb-jar");
    }

    public void perform(GraphRewrite event, EvaluationContext context, XmlFileModel payload) {
        Document doc = new XmlFileService(event.getGraphContext()).loadDocumentQuiet(payload);
        if (doc == null) {
            return;
        }
        this.extractMetadata(event.getGraphContext(), payload, doc);
    }

    private void extractMetadata(GraphContext context, XmlFileModel xmlModel, Document doc) {
        TechnologyTagService technologyTagService = new TechnologyTagService(context);
        technologyTagService.addTagToFileModel((FileModel)xmlModel, TECH_TAG, TECH_TAG_LEVEL);
        if (xmlModel.getDoctype() != null) {
            if (!this.processDoctypeMatches(xmlModel.getDoctype())) {
                return;
            }
            String version = this.processDoctypeVersion(xmlModel.getDoctype());
            this.extractMetadata(context, xmlModel, doc, version);
        } else {
            String version;
            String namespace = JOOX.$((Document)doc).find("ejb-jar").namespaceURI();
            if (StringUtils.isBlank((String)namespace)) {
                namespace = doc.getFirstChild().getNamespaceURI();
            }
            if (StringUtils.isBlank((String)(version = JOOX.$((Document)doc).attr("version")))) {
                for (NamespaceMetaModel ns : xmlModel.getNamespaces()) {
                    if (!StringUtils.equals((String)ns.getURI(), (String)namespace)) continue;
                    version = NamespaceUtils.extractVersion((String)ns.getSchemaLocation());
                }
            }
            this.extractMetadata(context, xmlModel, doc, version);
        }
    }

    private void extractMetadata(GraphContext ctx, XmlFileModel xml, Document doc, String versionInformation) {
        EjbDeploymentDescriptorModel facet = (EjbDeploymentDescriptorModel)GraphService.addTypeToModel((GraphContext)ctx, (WindupVertexFrame)xml, EjbDeploymentDescriptorModel.class);
        if (StringUtils.isNotBlank((String)versionInformation)) {
            facet.setSpecificationVersion(versionInformation);
        }
        for (Element element : JOOX.$((Document)doc).find("session").get()) {
            this.processSessionBeanElement(ctx, facet, element);
        }
        for (Element element : JOOX.$((Document)doc).find("message-driven").get()) {
            this.processMessageDrivenElement(ctx, facet, element);
        }
        for (Element element : JOOX.$((Document)doc).find("entity").get()) {
            this.processEntityElement(ctx, facet, element);
        }
    }

    private boolean processDoctypeMatches(DoctypeMetaModel entry) {
        if (StringUtils.isNotBlank((String)entry.getPublicId()) && Pattern.matches(dtdRegex, entry.getPublicId())) {
            return true;
        }
        return StringUtils.isNotBlank((String)entry.getSystemId()) && Pattern.matches(dtdRegex, entry.getSystemId());
    }

    private String processDoctypeVersion(DoctypeMetaModel entry) {
        String publicId = entry.getPublicId();
        String systemId = entry.getSystemId();
        String versionInformation = DoctypeUtils.extractVersion((String)publicId, (String)systemId);
        return versionInformation;
    }

    private void processSessionBeanElement(GraphContext ctx, EjbDeploymentDescriptorModel ejbConfig, Element element) {
        String ejbClz;
        String remoteClz;
        String homeClz;
        String localHomeClz;
        JavaClassService javaClassService = new JavaClassService(ctx);
        JavaClassModel home = null;
        JavaClassModel localHome = null;
        JavaClassModel remote = null;
        JavaClassModel local = null;
        JavaClassModel ejb = null;
        String ejbId = this.extractAttributeAndTrim(element, "id");
        String displayName = this.extractChildTagAndTrim(element, "display-name");
        String ejbName = this.extractChildTagAndTrim(element, "ejb-name");
        String localClz = this.extractChildTagAndTrim(element, "local");
        if (localClz != null) {
            local = javaClassService.getOrCreate(localClz);
        }
        if ((localHomeClz = this.extractChildTagAndTrim(element, "local-home")) != null) {
            localHome = javaClassService.getOrCreate(localHomeClz);
        }
        if ((homeClz = this.extractChildTagAndTrim(element, "home")) != null) {
            home = javaClassService.getOrCreate(homeClz);
        }
        if ((remoteClz = this.extractChildTagAndTrim(element, "remote")) != null) {
            remote = javaClassService.getOrCreate(remoteClz);
        }
        if ((ejbClz = this.extractChildTagAndTrim(element, "ejb-class")) != null) {
            ejb = javaClassService.getOrCreate(ejbClz);
        }
        String sessionType = this.extractChildTagAndTrim(element, "session-type");
        String transactionType = this.extractChildTagAndTrim(element, "transaction-type");
        GraphService sessionBeanService = new GraphService(ctx, EjbSessionBeanModel.class);
        EjbSessionBeanModel sessionBean = (EjbSessionBeanModel)sessionBeanService.create();
        sessionBean.setEjbId(ejbId);
        sessionBean.setDisplayName(displayName);
        sessionBean.setBeanName(ejbName);
        sessionBean.setEjbLocal(local);
        sessionBean.setEjbLocalHome(localHome);
        sessionBean.setEjbHome(home);
        sessionBean.setEjbRemote(remote);
        sessionBean.setEjbClass(ejb);
        sessionBean.setSessionType(sessionType);
        sessionBean.setTransactionType(transactionType);
        List<EnvironmentReferenceModel> refs = this.processEnvironmentReference(ctx, element);
        for (EnvironmentReferenceModel ref : refs) {
            sessionBean.addEnvironmentReference(ref);
        }
        ejbConfig.addEjbSessionBean(sessionBean);
    }

    private void processMessageDrivenElement(GraphContext ctx, EjbDeploymentDescriptorModel ejbConfig, Element element) {
        JavaClassService javaClassService = new JavaClassService(ctx);
        JavaClassModel ejb = null;
        String ejbId = this.extractAttributeAndTrim(element, "id");
        String displayName = this.extractChildTagAndTrim(element, "display-name");
        String ejbName = this.extractChildTagAndTrim(element, "ejb-name");
        String ejbClz = this.extractChildTagAndTrim(element, "ejb-class");
        if (ejbClz != null) {
            ejb = javaClassService.getOrCreate(ejbClz);
        }
        String sessionType = this.extractChildTagAndTrim(element, "session-type");
        String transactionType = this.extractChildTagAndTrim(element, "transaction-type");
        GraphService sessionBeanService = new GraphService(ctx, EjbMessageDrivenModel.class);
        EjbMessageDrivenModel mdb = (EjbMessageDrivenModel)sessionBeanService.create();
        mdb.setEjbClass(ejb);
        mdb.setBeanName(ejbName);
        mdb.setDisplayName(displayName);
        mdb.setEjbId(ejbId);
        mdb.setSessionType(sessionType);
        mdb.setTransactionType(transactionType);
        List<EnvironmentReferenceModel> refs = this.processEnvironmentReference(ctx, element);
        for (EnvironmentReferenceModel ref : refs) {
            mdb.addEnvironmentReference(ref);
        }
        ejbConfig.addMessageDriven(mdb);
    }

    private void processEntityElement(GraphContext ctx, EjbDeploymentDescriptorModel ejbConfig, Element element) {
        String ejbClz;
        String localHomeClz;
        JavaClassService javaClassService = new JavaClassService(ctx);
        JavaClassModel localHome = null;
        JavaClassModel local = null;
        JavaClassModel ejb = null;
        String ejbId = this.extractAttributeAndTrim(element, "id");
        String displayName = this.extractChildTagAndTrim(element, "display-name");
        String ejbName = this.extractChildTagAndTrim(element, "ejb-name");
        String localClz = this.extractChildTagAndTrim(element, "local");
        if (localClz != null) {
            local = javaClassService.getOrCreate(localClz);
        }
        if ((localHomeClz = this.extractChildTagAndTrim(element, "local-home")) != null) {
            localHome = javaClassService.getOrCreate(localHomeClz);
        }
        if ((ejbClz = this.extractChildTagAndTrim(element, "ejb-class")) != null) {
            ejb = javaClassService.getOrCreate(ejbClz);
        }
        String persistenceType = this.extractChildTagAndTrim(element, "persistence-type");
        GraphService ejbEntityService = new GraphService(ctx, EjbEntityBeanModel.class);
        EjbEntityBeanModel entity = (EjbEntityBeanModel)ejbEntityService.create();
        entity.setPersistenceType(persistenceType);
        entity.setEjbId(ejbId);
        entity.setDisplayName(displayName);
        entity.setBeanName(ejbName);
        entity.setEjbClass(ejb);
        entity.setEjbLocalHome(localHome);
        entity.setEjbLocal(local);
        List<EnvironmentReferenceModel> refs = this.processEnvironmentReference(ctx, element);
        for (EnvironmentReferenceModel ref : refs) {
            entity.addEnvironmentReference(ref);
        }
        ejbConfig.addEjbEntityBean(entity);
    }

    private List<EnvironmentReferenceModel> processEnvironmentReference(GraphContext context, Element element) {
        EnvironmentReferenceService environmentReferenceService = new EnvironmentReferenceService(context);
        LinkedList<EnvironmentReferenceModel> resources = new LinkedList<EnvironmentReferenceModel>();
        List queueReferences = JOOX.$((Element)element).find("resource-env-ref").get();
        for (Element e : queueReferences) {
            String type = JOOX.$((Element)e).child("resource-env-ref-type").text();
            String name = JOOX.$((Element)e).child("resource-env-ref-name").text();
            type = StringUtils.trim((String)type);
            EnvironmentReferenceModel ref = environmentReferenceService.findEnvironmentReference(name = StringUtils.trim((String)name), type);
            if (ref == null) {
                ref = (EnvironmentReferenceModel)environmentReferenceService.create();
                ref.setName(name);
                ref.setReferenceType(type);
            }
            resources.add(ref);
        }
        return resources;
    }

    private String extractAttributeAndTrim(Element element, String property) {
        String result = JOOX.$((Element)element).attr(property);
        return StringUtils.trimToNull((String)result);
    }

    private String extractChildTagAndTrim(Element element, String property) {
        String result = JOOX.$((Element)element).find(property).first().text();
        return StringUtils.trimToNull((String)result);
    }
}

