/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.projects.util;

import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.repository.layout.FlatRepositoryLayout;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.RepositoryPolicy;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.jboss.forge.addon.maven.projects.P2ArtifactRepositoryLayout;

public final class RepositoryUtils {
    private RepositoryUtils() {
    }

    public static Proxy convertFromMavenProxy(org.apache.maven.settings.Proxy proxy) {
        Proxy result = null;
        if (proxy != null) {
            Authentication auth = new AuthenticationBuilder().addUsername(proxy.getUsername()).addPassword(proxy.getPassword()).build();
            result = new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), auth);
        }
        return result;
    }

    public static ArtifactRepository convertFromMavenSettingsRepository(Repository repository) {
        RepositoryPolicy snapshots;
        MavenArtifactRepository result = new MavenArtifactRepository();
        result.setId(repository.getId());
        result.setUrl(repository.getUrl());
        String layout = repository.getLayout();
        if ("default".equals(layout)) {
            result.setLayout((ArtifactRepositoryLayout)new DefaultRepositoryLayout());
        } else if ("flat".equals(layout)) {
            result.setLayout((ArtifactRepositoryLayout)new FlatRepositoryLayout());
        } else if ("p2".equals(layout)) {
            result.setLayout((ArtifactRepositoryLayout)new P2ArtifactRepositoryLayout());
        }
        RepositoryPolicy releases = repository.getReleases();
        if (releases != null) {
            result.setReleaseUpdatePolicy(new ArtifactRepositoryPolicy(releases.isEnabled(), releases.getUpdatePolicy(), releases.getChecksumPolicy()));
        }
        if ((snapshots = repository.getSnapshots()) != null) {
            result.setSnapshotUpdatePolicy(new ArtifactRepositoryPolicy(snapshots.isEnabled(), snapshots.getUpdatePolicy(), snapshots.getChecksumPolicy()));
        }
        return result;
    }

    public static ArtifactRepository toArtifactRepository(String id, String url, String layout, boolean containsReleases, boolean containsSnapshots) {
        MavenArtifactRepository result = new MavenArtifactRepository();
        result.setId(id);
        result.setUrl(url);
        if (layout == null || layout.isEmpty() || "default".equals(layout)) {
            result.setLayout((ArtifactRepositoryLayout)new DefaultRepositoryLayout());
        } else if ("flat".equals(layout)) {
            result.setLayout((ArtifactRepositoryLayout)new FlatRepositoryLayout());
        } else if ("p2".equals(layout)) {
            result.setLayout((ArtifactRepositoryLayout)new P2ArtifactRepositoryLayout());
        }
        result.setReleaseUpdatePolicy(new ArtifactRepositoryPolicy(containsReleases, "never", "warn"));
        result.setSnapshotUpdatePolicy(new ArtifactRepositoryPolicy(containsSnapshots, "daily", "warn"));
        return result;
    }
}

