/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decompiler.procyon;

import com.strobel.assembler.InputTypeLoader;
import com.strobel.assembler.metadata.ClasspathTypeLoader;
import com.strobel.assembler.metadata.CompositeTypeLoader;
import com.strobel.assembler.metadata.IMetadataResolver;
import com.strobel.assembler.metadata.ITypeLoader;
import com.strobel.assembler.metadata.JarTypeLoader;
import com.strobel.assembler.metadata.MetadataParser;
import com.strobel.assembler.metadata.MetadataSystem;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.decompiler.DecompilationOptions;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.ITextOutput;
import com.strobel.decompiler.PlainTextOutput;
import com.strobel.decompiler.languages.BytecodeLanguage;
import com.strobel.decompiler.languages.TypeDecompilationResults;
import com.strobel.decompiler.languages.java.JavaFormattingOptions;
import com.strobel.io.PathHelper;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.decompiler.api.DecompilationException;
import org.jboss.windup.decompiler.api.DecompilationFailure;
import org.jboss.windup.decompiler.api.DecompilationResult;
import org.jboss.windup.decompiler.api.Decompiler;
import org.jboss.windup.decompiler.procyon.Checks;
import org.jboss.windup.decompiler.procyon.FileOutputWriter;
import org.jboss.windup.decompiler.procyon.LineNumberFormatter;
import org.jboss.windup.decompiler.procyon.NoRetryMetadataSystem;
import org.jboss.windup.decompiler.procyon.ProcyonConfiguration;
import org.jboss.windup.decompiler.util.Filter;

public class ProcyonDecompiler
implements Decompiler {
    private static final Logger log = Logger.getLogger(ProcyonDecompiler.class.getName());
    private final ProcyonConfiguration procyonConf;

    public ProcyonDecompiler() {
        this.procyonConf = new ProcyonConfiguration();
    }

    public ProcyonDecompiler(ProcyonConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration must not be null.");
        }
        this.procyonConf = configuration;
    }

    public DecompilationResult decompileClassFile(File rootDir, Path classFilePath, File outputDir) throws DecompilationException {
        Checks.checkDirectoryToBeRead(rootDir, "Classes root dir");
        File classFile = rootDir.toPath().resolve(classFilePath).toFile();
        Checks.checkFileToBeRead(classFile, "Class file");
        Checks.checkDirectoryToBeFilled(outputDir, "Output directory");
        log.info("Decompiling .class '" + classFilePath + "' to '" + outputDir.getPath() + "'");
        String name = classFilePath.toString();
        String typeName = StringUtils.removeEnd((String)name, (String)".class");
        DecompilationResult res = new DecompilationResult();
        try {
            DecompilerSettings settings = this.getDefaultSettings(outputDir);
            this.procyonConf.setDecompilerSettings(settings);
            CompositeTypeLoader typeLoader = new CompositeTypeLoader(new ITypeLoader[]{new ClasspathTypeLoader(rootDir.getPath()), new ClasspathTypeLoader()});
            MetadataSystem metadataSystem = new MetadataSystem((ITypeLoader)typeLoader);
            File outputFile = this.decompileType(metadataSystem, typeName);
            res.addDecompiled(classFilePath.toString(), outputFile.getAbsolutePath());
        }
        catch (Throwable e) {
            DecompilationFailure failure = new DecompilationFailure("Error during decompilation of " + classFilePath.toString() + ":\n    " + e.getMessage(), name, e);
            log.severe(failure.getMessage());
            res.addFailure(failure);
        }
        return res;
    }

    public DecompilationResult decompileDirectory(File rootDir, File outputDir) throws DecompilationException {
        log.info("Decompiling directory '" + rootDir.getAbsolutePath() + "' to '" + outputDir.getPath());
        DecompilationResult result = new DecompilationResult();
        Path subPath = Paths.get("", new String[0]);
        this.decompileDirectory(rootDir, outputDir, subPath, result);
        return result;
    }

    private void decompileDirectory(File rootDir, File outputDir, Path subPath, DecompilationResult result) throws DecompilationException {
        Checks.checkDirectoryToBeRead(rootDir, "Directory to decompile");
        Checks.checkDirectoryToBeFilled(outputDir, "Output directory");
        log.info("Decompiling subdir '" + subPath + "'");
        DecompilerSettings settings = this.getDefaultSettings(outputDir);
        NoRetryMetadataSystem metadataSystem = new NoRetryMetadataSystem((ITypeLoader)new InputTypeLoader());
        File curDirFull = rootDir.toPath().resolve(subPath).toFile();
        List<File> files = Arrays.asList(curDirFull.listFiles());
        for (File file : files) {
            if (file.isDirectory()) {
                Path subPathNew = subPath.resolve(file.getName());
                this.decompileDirectory(rootDir, outputDir, subPathNew, result);
                continue;
            }
            if (!file.getName().endsWith(".class") || file.getName().contains("$")) continue;
            String fileSubPath = subPath.resolve(file.getName()).toString();
            String fqcn = StringUtils.removeEnd((String)fileSubPath, (String)".class").replace('/', '.');
            try {
                File outputFile = this.decompileType(metadataSystem, fqcn);
                if (null == outputFile) {
                    throw new IllegalStateException("Unknown Procyon error, type not found.");
                }
                result.addDecompiled(file.getAbsolutePath(), outputFile.getAbsolutePath());
            }
            catch (Throwable ex) {
                DecompilationFailure failure = new DecompilationFailure("Error during decompilation of " + rootDir.getPath() + " / " + fileSubPath + ":\n    " + ex.getMessage(), fileSubPath.toString(), ex);
                log.log(Level.SEVERE, failure.getMessage(), failure);
                result.addFailure(failure);
            }
        }
    }

    public DecompilationResult decompileArchive(File archive, File outputDir) throws DecompilationException {
        return this.decompileArchive(archive, outputDir, null);
    }

    public DecompilationResult decompileArchive(File archive, File outputDir, Filter<ZipEntry> filter) throws DecompilationException {
        Checks.checkFileToBeRead(archive, "Archive to decompile");
        Checks.checkDirectoryToBeFilled(outputDir, "Output directory");
        log.info("Decompiling archive '" + archive.getAbsolutePath() + "' to '" + outputDir.getAbsolutePath() + "'");
        JarFile jar = this.loadJar(archive);
        DecompilerSettings settings = this.getDefaultSettings(outputDir);
        settings.setTypeLoader((ITypeLoader)new CompositeTypeLoader(new ITypeLoader[]{new JarTypeLoader(jar), settings.getTypeLoader()}));
        NoRetryMetadataSystem metadataSystem = new NoRetryMetadataSystem(settings.getTypeLoader());
        int classesDecompiled = 0;
        DecompilationResult res = new DecompilationResult();
        Filter.Result filterRes = Filter.Result.ACCEPT;
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (filter != null) {
                filterRes = filter.decide((Object)entry);
            }
            if (filterRes == Filter.Result.REJECT) continue;
            if (filterRes == Filter.Result.STOP) break;
            String name = entry.getName();
            if (!name.endsWith(".class")) continue;
            String typeName = StringUtils.removeEnd((String)name, (String)".class");
            try {
                File outputFile = this.decompileType(metadataSystem, typeName);
                if (outputFile != null) {
                    res.addDecompiled(name, outputFile.getAbsolutePath());
                }
                if (++classesDecompiled % 100 != 0) continue;
                metadataSystem = new NoRetryMetadataSystem(settings.getTypeLoader());
            }
            catch (Throwable th) {
                String msg = "Error during decompilation of " + archive.getPath() + "!" + name + ":\n    " + th.getMessage();
                DecompilationFailure ex = new DecompilationFailure(msg, name, th);
                log.log(Level.SEVERE, msg, ex);
                res.addFailure(ex);
            }
        }
        return res;
    }

    private File decompileType(MetadataSystem metadataSystem, String typeName) throws IOException {
        boolean nested;
        TypeReference type;
        log.fine("Decompiling " + typeName);
        if (typeName.length() == 1) {
            MetadataParser parser = new MetadataParser(IMetadataResolver.EMPTY);
            TypeReference reference = parser.parseTypeDescriptor(typeName);
            type = metadataSystem.resolve(reference);
        } else {
            type = metadataSystem.lookupType(typeName);
        }
        if (type == null) {
            log.severe("Failed to load class: " + typeName);
            return null;
        }
        TypeDefinition resolvedType = type.resolve();
        if (resolvedType == null) {
            log.severe("Failed to resolve type: " + typeName);
            return null;
        }
        boolean bl = nested = resolvedType.isNested() || resolvedType.isAnonymous() || resolvedType.isSynthetic();
        if (!this.procyonConf.isIncludeNested() && nested) {
            return null;
        }
        DecompilerSettings settings = this.procyonConf.getDecompilerSettings();
        settings.setFormattingOptions(new JavaFormattingOptions());
        FileOutputWriter writer = ProcyonDecompiler.createFileWriter(resolvedType, settings);
        PlainTextOutput output = new PlainTextOutput((Writer)writer);
        output.setUnicodeOutputEnabled(settings.isUnicodeOutputEnabled());
        if (settings.getLanguage() instanceof BytecodeLanguage) {
            output.setIndentToken("  ");
        }
        DecompilationOptions options = new DecompilationOptions();
        options.setSettings(settings);
        TypeDecompilationResults results = settings.getLanguage().decompileType(resolvedType, (ITextOutput)output, options);
        writer.flush();
        writer.close();
        List lineNumberPositions = results.getLineNumberPositions();
        if (!this.procyonConf.getLineNumberOptions().isEmpty()) {
            LineNumberFormatter lineFormatter = new LineNumberFormatter(writer.getFile(), lineNumberPositions, this.procyonConf.getLineNumberOptions());
            lineFormatter.reformatFile();
        }
        return writer.getFile();
    }

    private DecompilerSettings getDefaultSettings(File outputDir) {
        DecompilerSettings settings = this.procyonConf.getDecompilerSettings();
        if (settings == null) {
            settings = new DecompilerSettings();
            this.procyonConf.setDecompilerSettings(settings);
        }
        settings.setOutputDirectory(outputDir.getPath());
        settings.setShowSyntheticMembers(false);
        settings.setForceExplicitImports(true);
        if (settings.getTypeLoader() == null) {
            settings.setTypeLoader((ITypeLoader)new ClasspathTypeLoader());
        }
        return settings;
    }

    private JarFile loadJar(File archive) throws DecompilationException {
        JarFile jar;
        try {
            jar = new JarFile(archive);
        }
        catch (IOException ex) {
            throw new DecompilationException("Can't load .jar: " + archive.getPath(), (Throwable)ex);
        }
        return jar;
    }

    private static FileOutputWriter createFileWriter(TypeDefinition type, DecompilerSettings settings) throws IOException {
        String outputDirectory = settings.getOutputDirectory();
        String fileName = type.getName() + settings.getLanguage().getFileExtension();
        String packageName = type.getPackageName();
        String subDir = StringUtils.defaultIfEmpty((String)packageName, (String)"").replace('.', File.separatorChar);
        String outputPath = PathHelper.combine((String)outputDirectory, (String)subDir, (String)fileName);
        File outputFile = new File(outputPath);
        File parentDir = outputFile.getParentFile();
        if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
            throw new IllegalStateException("Could not create directory:" + parentDir);
        }
        if (!outputFile.exists() && !outputFile.createNewFile()) {
            throw new IllegalStateException("Could not create output file: " + outputPath);
        }
        return new FileOutputWriter(outputFile, settings);
    }
}

