/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.service;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.util.FilenameUtil;
import org.jboss.windup.util.exception.WindupException;

public class ReportService
extends GraphService<ReportModel> {
    private static final String REPORTS_DIR = "reports";
    private static Set<String> usedFilenames = new HashSet<String>();
    private AtomicInteger index = new AtomicInteger(1);

    public ReportService(GraphContext context) {
        super(context, ReportModel.class);
    }

    public String getReportDirectory() {
        WindupConfigurationModel cfg = ReportService.getConfigurationModel((GraphContext)this.getGraphContext());
        Path path = cfg.getOutputPath().asFile().toPath().resolve(REPORTS_DIR);
        if (!Files.isDirectory(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new WindupException("Failed to create directory: " + path.toString() + " due to: " + e.getMessage(), (Throwable)e);
            }
        }
        return path.toAbsolutePath().toString();
    }

    public void setUniqueFilename(ReportModel model, String baseFilename, String extension) {
        String filename = FilenameUtil.cleanFileName((String)baseFilename) + "." + this.index.getAndIncrement() + "." + extension;
        int i = 1;
        while (usedFilenames.contains(filename.toString())) {
            filename = FilenameUtil.cleanFileName((String)baseFilename) + "." + this.index.getAndIncrement() + "." + extension;
            ++i;
        }
        usedFilenames.add(filename);
        model.setReportFilename(filename);
    }
}

