/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.binary;

import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import com.tinkerpop.pipes.PipeFunction;
import java.util.List;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.RulePhase;
import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.operation.Log;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryGremlinCriterion;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.rules.apps.java.binary.ProcyonDecompilerOperation;
import org.jboss.windup.rules.apps.java.model.JavaClassFileModel;
import org.jboss.windup.rules.apps.java.scan.provider.AnalyzeJavaFilesRuleProvider;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;

public class DecompileArchivesRuleProvider
extends WindupRuleProvider {
    public RulePhase getPhase() {
        return RulePhase.INITIAL_ANALYSIS;
    }

    public List<Class<? extends WindupRuleProvider>> getExecuteBefore() {
        return this.asClassList(new Class[]{AnalyzeJavaFilesRuleProvider.class});
    }

    public Configuration getConfiguration(GraphContext context) {
        ShouldDecompileCriterion shouldDecompileCriterion = new ShouldDecompileCriterion();
        return ConfigurationBuilder.begin().addRule().when((Condition)Query.find(ArchiveModel.class).piped((QueryGremlinCriterion)shouldDecompileCriterion)).perform((Operation)new ProcyonDecompilerOperation()).otherwise((Operation)Log.message((Logger.Level)Logger.Level.WARN, (String)"No archives to decompile."));
    }

    private class ShouldDecompileCriterion
    implements QueryGremlinCriterion {
        private ShouldDecompileCriterion() {
        }

        public void query(final GraphRewrite event, GremlinPipeline<Vertex, Vertex> pipeline) {
            pipeline.filter((PipeFunction)new PipeFunction<Vertex, Boolean>(){

                public Boolean compute(Vertex argument) {
                    ArchiveModel archive = (ArchiveModel)event.getGraphContext().getFramed().frame(argument, ArchiveModel.class);
                    WindupConfigurationService windupConfigurationService = new WindupConfigurationService(event.getGraphContext());
                    for (FileModel fileModel : archive.getContainedFileModels()) {
                        JavaClassFileModel javaClassFileModel;
                        if (!(fileModel instanceof JavaClassFileModel) || !windupConfigurationService.shouldScanPackage((javaClassFileModel = (JavaClassFileModel)fileModel).getPackageName())) continue;
                        return true;
                    }
                    return false;
                }
            });
        }
    }
}

