/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.reporting.freemarker;

import freemarker.ext.beans.StringModel;
import freemarker.template.TemplateModelException;
import java.util.List;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.rules.apps.java.model.JavaClassFileModel;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;

public class GetPrettyPathForFile
implements WindupFreeMarkerMethod {
    public Object exec(List arguments) throws TemplateModelException {
        if (arguments.size() != 1) {
            throw new TemplateModelException("Error, method expects one argument (FileModel)");
        }
        StringModel stringModelArg = (StringModel)arguments.get(0);
        FileModel fileModel = (FileModel)stringModelArg.getWrappedObject();
        if (fileModel instanceof JavaClassFileModel) {
            JavaClassFileModel jcfm = (JavaClassFileModel)fileModel;
            return jcfm.getJavaClass().getQualifiedName();
        }
        if (fileModel instanceof JavaSourceFileModel) {
            JavaSourceFileModel javaSourceModel = (JavaSourceFileModel)fileModel;
            String filename = fileModel.getFileName();
            String packageName = javaSourceModel.getPackageName();
            if (filename.endsWith(".java")) {
                filename = filename.substring(0, filename.length() - 5);
            }
            return packageName == null || packageName.equals("") ? filename : packageName + "." + filename;
        }
        return fileModel.getPrettyPathWithinProject();
    }

    public String getMethodName() {
        return "getPrettyPathForFile";
    }

    public void setGraphContext(GraphContext context) {
    }
}

