/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.operation;

import java.io.File;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.operation.ruleelement.AbstractIterationOperation;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileModelService;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class RecurseDirectoryAndAddFiles
extends AbstractIterationOperation<FileModel> {
    private RecurseDirectoryAndAddFiles(String variableName) {
        super(variableName);
    }

    public RecurseDirectoryAndAddFiles() {
    }

    public static RecurseDirectoryAndAddFiles startingAt(String variableName) {
        return new RecurseDirectoryAndAddFiles(variableName);
    }

    public void perform(GraphRewrite event, EvaluationContext context, FileModel resourceModel) {
        FileModelService fileModelService = new FileModelService(event.getGraphContext());
        this.recurseAndAddFiles(fileModelService, resourceModel);
    }

    private void recurseAndAddFiles(FileModelService fileService, FileModel file) {
        File[] subFiles;
        String filePath = file.getFilePath();
        File fileReference = new File(filePath);
        if (fileReference.isDirectory() && (subFiles = fileReference.listFiles()) != null) {
            for (File reference : subFiles) {
                FileModel subFile = fileService.createByFilePath(file, reference.getAbsolutePath());
                this.recurseAndAddFiles(fileService, subFile);
            }
        }
    }
}

