/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.operation;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.operation.ruleelement.AbstractIterationOperation;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileModelService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.util.ZipUtil;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnzipArchiveToOutputFolder
extends AbstractIterationOperation<ArchiveModel> {
    private static final String ARCHIVES = "archives";
    private static final Logger LOG = LoggerFactory.getLogger(UnzipArchiveToOutputFolder.class);

    public UnzipArchiveToOutputFolder(String variableName) {
        super(variableName);
    }

    public UnzipArchiveToOutputFolder() {
    }

    public static UnzipArchiveToOutputFolder unzip(String variableName) {
        return new UnzipArchiveToOutputFolder(variableName);
    }

    public static UnzipArchiveToOutputFolder unzip() {
        return new UnzipArchiveToOutputFolder();
    }

    public void perform(GraphRewrite event, EvaluationContext context, ArchiveModel payload) {
        LOG.info("Unzipping archive: " + payload.toPrettyString());
        File zipFile = payload.asFile();
        if (!zipFile.isFile()) {
            String msg = "Input path doesn't point to a file: " + zipFile.getAbsolutePath();
            throw new WindupException(msg);
        }
        WindupConfigurationModel cfg = GraphService.getConfigurationModel((GraphContext)event.getGraphContext());
        String windupOutputFolder = cfg.getOutputPath().getFilePath();
        Path windupTempUnzippedArchiveFolder = Paths.get(windupOutputFolder, ARCHIVES);
        if (!Files.isDirectory(windupTempUnzippedArchiveFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(windupTempUnzippedArchiveFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new WindupException("Failed to create temporary folder: " + windupTempUnzippedArchiveFolder + " due to: " + e.getMessage(), (Throwable)e);
            }
        }
        this.unzipToTempDirectory(event.getGraphContext(), windupTempUnzippedArchiveFolder, zipFile, payload);
    }

    private Path getAppArchiveFolder(Path tempFolder, String appArchiveName) {
        Path appArchiveFolder = Paths.get(tempFolder.toString(), appArchiveName);
        int fileIdx = 1;
        while (Files.exists(appArchiveFolder, new LinkOption[0])) {
            appArchiveFolder = Paths.get(tempFolder.toString(), appArchiveName + "." + fileIdx);
            ++fileIdx;
        }
        return appArchiveFolder;
    }

    private void unzipToTempDirectory(GraphContext context, Path tempFolder, File inputZipFile, ArchiveModel archiveModel) {
        FileModelService fileService = new FileModelService(context);
        String appArchiveName = archiveModel.getArchiveName();
        Path appArchiveFolder = this.getAppArchiveFolder(tempFolder, appArchiveName);
        try {
            Files.createDirectories(appArchiveFolder, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new WindupException("Could not create a temporary directory for application \"" + appArchiveName + "\" at \"" + appArchiveFolder.toString() + "\" due to: " + e.getMessage(), (Throwable)e);
        }
        LOG.info("Unzipping " + inputZipFile.getPath() + " to " + appArchiveFolder.toString());
        try {
            ZipUtil.unzipToFolder((File)inputZipFile, (File)appArchiveFolder.toFile());
        }
        catch (Throwable e) {
            throw new WindupException("Unzipping archive: " + inputZipFile.getAbsolutePath() + " failed due to: " + e.getMessage(), e);
        }
        FileModel newFileModel = fileService.createByFilePath(appArchiveFolder.toString());
        archiveModel.setUnzippedDirectory(newFileModel);
        newFileModel.setParentArchive(archiveModel);
        this.recurseAndAddFiles(context, tempFolder, fileService, archiveModel, newFileModel);
    }

    private void recurseAndAddFiles(GraphContext context, Path tempFolder, FileModelService fileService, ArchiveModel archiveModel, FileModel parentFileModel) {
        File[] subFiles;
        File fileReference = parentFileModel.asFile();
        if (fileReference.isDirectory() && (subFiles = fileReference.listFiles()) != null) {
            for (File subFile : subFiles) {
                FileModel subFileModel = fileService.createByFilePath(parentFileModel, subFile.getAbsolutePath());
                subFileModel.setParentArchive(archiveModel);
                if (subFile.isFile() && ZipUtil.endsWithZipExtension((String)subFileModel.getFilePath())) {
                    File newZipFile = subFileModel.asFile();
                    ArchiveModel newArchiveModel = (ArchiveModel)GraphService.addTypeToModel((GraphContext)context, (WindupVertexFrame)subFileModel, ArchiveModel.class);
                    newArchiveModel.setParentArchive(archiveModel);
                    newArchiveModel.setArchiveName(newZipFile.getName());
                    archiveModel.addChildArchive(newArchiveModel);
                    this.unzipToTempDirectory(context, tempFolder, newZipFile, newArchiveModel);
                }
                if (!subFile.isDirectory()) continue;
                this.recurseAndAddFiles(context, tempFolder, fileService, archiveModel, subFileModel);
            }
        }
    }
}

