/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.provider;

import com.thinkaurelius.titan.core.TitanGraph;
import java.util.List;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.RulePhase;
import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.operation.ruleelement.AbstractIterationOperation;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryPropertyComparisonType;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.rules.apps.java.binary.DecompileArchivesRuleProvider;
import org.jboss.windup.rules.apps.java.scan.operation.AddClassFileMetadata;
import org.jboss.windup.rules.apps.java.scan.provider.UnzipArchivesToOutputRuleProvider;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class IndexClassFilesRuleProvider
extends WindupRuleProvider {
    public RulePhase getPhase() {
        return RulePhase.INITIAL_ANALYSIS;
    }

    public List<Class<? extends WindupRuleProvider>> getExecuteAfter() {
        return this.asClassList(new Class[]{UnzipArchivesToOutputRuleProvider.class});
    }

    public List<Class<? extends WindupRuleProvider>> getExecuteBefore() {
        return this.asClassList(new Class[]{DecompileArchivesRuleProvider.class});
    }

    public Configuration getConfiguration(GraphContext context) {
        AbstractIterationOperation<FileModel> commitPeriodically = new AbstractIterationOperation<FileModel>(){
            private int uncommittedIterations = 0;

            public void perform(GraphRewrite event, EvaluationContext context, FileModel payload) {
                ++this.uncommittedIterations;
                if (this.uncommittedIterations > 10) {
                    ((TitanGraph)event.getGraphContext().getGraph().getBaseGraph()).commit();
                    this.uncommittedIterations = 0;
                }
            }
        };
        return ConfigurationBuilder.begin().addRule().when((Condition)Query.find(FileModel.class).withProperty("isDirectory", (Object)false).withProperty("filePath", QueryPropertyComparisonType.REGEX, (Object)".*\\.class")).perform((Operation)new AddClassFileMetadata().and((Operation)commitPeriodically));
    }
}

