/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.exec;

import java.nio.file.Path;
import javax.inject.Inject;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.windup.config.DefaultEvaluationContext;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.RuleLifecycleListener;
import org.jboss.windup.config.RuleSubset;
import org.jboss.windup.config.loader.WindupRuleLoader;
import org.jboss.windup.config.metadata.WindupRuleMetadata;
import org.jboss.windup.exec.DefaultRuleLifecycleListener;
import org.jboss.windup.exec.WindupProcessor;
import org.jboss.windup.exec.configuration.WindupConfiguration;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileModelService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.DefaultParameterValueStore;
import org.ocpsoft.rewrite.param.ParameterValueStore;

public class WindupProcessorImpl
implements WindupProcessor {
    @Inject
    private WindupRuleLoader windupConfigurationLoader;
    @Inject
    private Imported<RuleLifecycleListener> listeners;

    public void execute() {
        this.execute(new WindupConfiguration());
    }

    public void execute(WindupConfiguration windupConfiguration) {
        Assert.notNull((Object)windupConfiguration, (String)"Windup configuration must not be null. (Call default execution if no configuration is required.)");
        GraphContext context = windupConfiguration.getGraphContext();
        Assert.notNull((Object)context, (String)"Windup GraphContext must not be null!");
        context.setOptions(windupConfiguration.getOptionMap());
        WindupConfigurationModel configModel = WindupConfigurationService.getConfigurationModel((GraphContext)context);
        configModel.setInputPath(this.getFileModel(context, windupConfiguration.getInputPath()));
        configModel.setOutputPath(this.getFileModel(context, windupConfiguration.getOutputDirectory()));
        configModel.setOfflineMode(windupConfiguration.isOffline());
        if (windupConfiguration.getUserRulesDirectory() != null) {
            configModel.setUserRulesPath(this.getFileModel(context, windupConfiguration.getUserRulesDirectory()));
        }
        GraphRewrite event = new GraphRewrite(context);
        WindupRuleMetadata ruleMetadata = this.windupConfigurationLoader.loadConfiguration(context, windupConfiguration.getRuleProviderFilter());
        event.getRewriteContext().put(WindupRuleMetadata.class, (Object)ruleMetadata);
        Configuration rules = ruleMetadata.getConfiguration();
        RuleSubset ruleSubset = RuleSubset.create((Configuration)rules);
        if (windupConfiguration.getProgressMonitor() != null) {
            ruleSubset.addLifecycleListener((RuleLifecycleListener)new DefaultRuleLifecycleListener(windupConfiguration.getProgressMonitor(), rules));
        }
        for (RuleLifecycleListener listener : this.listeners) {
            ruleSubset.addLifecycleListener(listener);
        }
        ruleSubset.perform((Rewrite)event, this.createEvaluationContext());
    }

    private FileModel getFileModel(GraphContext context, Path path) {
        return new FileModelService(context).createByFilePath(path.toString());
    }

    private EvaluationContext createEvaluationContext() {
        DefaultEvaluationContext evaluationContext = new DefaultEvaluationContext();
        DefaultParameterValueStore values = new DefaultParameterValueStore();
        evaluationContext.put(ParameterValueStore.class, (Object)values);
        return evaluationContext;
    }
}

