/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.Order;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.QueryDescription;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.core.TitanGraphQuery;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.attribute.Cmp;
import com.thinkaurelius.titan.core.schema.SchemaStatus;
import com.thinkaurelius.titan.core.schema.TitanSchemaType;
import com.thinkaurelius.titan.graphdb.database.IndexSerializer;
import com.thinkaurelius.titan.graphdb.internal.ElementCategory;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.internal.OrderList;
import com.thinkaurelius.titan.graphdb.query.BackendQueryHolder;
import com.thinkaurelius.titan.graphdb.query.QueryProcessor;
import com.thinkaurelius.titan.graphdb.query.QueryUtil;
import com.thinkaurelius.titan.graphdb.query.StandardQueryDescription;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import com.thinkaurelius.titan.graphdb.query.condition.And;
import com.thinkaurelius.titan.graphdb.query.condition.Condition;
import com.thinkaurelius.titan.graphdb.query.condition.ConditionUtil;
import com.thinkaurelius.titan.graphdb.query.condition.PredicateCondition;
import com.thinkaurelius.titan.graphdb.query.graph.GraphCentricQuery;
import com.thinkaurelius.titan.graphdb.query.graph.JointIndexQuery;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.CompositeIndexType;
import com.thinkaurelius.titan.graphdb.types.IndexField;
import com.thinkaurelius.titan.graphdb.types.IndexType;
import com.thinkaurelius.titan.graphdb.types.MixedIndexType;
import com.thinkaurelius.titan.graphdb.types.ParameterIndexField;
import com.thinkaurelius.titan.graphdb.types.system.ImplicitKey;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Query;
import com.tinkerpop.blueprints.Vertex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphCentricQueryBuilder
implements TitanGraphQuery<GraphCentricQueryBuilder> {
    private static final Logger log = LoggerFactory.getLogger(GraphCentricQueryBuilder.class);
    private final StandardTitanTx tx;
    private final IndexSerializer serializer;
    private List<PredicateCondition<String, TitanElement>> constraints;
    private OrderList orders = new OrderList();
    private int limit = Integer.MAX_VALUE;
    private static final int DEFAULT_NO_LIMIT = 100;
    private static final int MAX_BASE_LIMIT = 20000;
    private static final int HARD_MAX_LIMIT = 50000;
    private static final double EQUAL_CONDITION_SCORE = 4.0;
    private static final double OTHER_CONDITION_SCORE = 1.0;
    private static final double ORDER_MATCH = 2.0;
    private static final double ALREADY_MATCHED_ADJUSTOR = 0.1;
    private static final double CARDINALITY_SINGE_SCORE = 1000.0;
    private static final double CARDINALITY_OTHER_SCORE = 1000.0;

    public GraphCentricQueryBuilder(StandardTitanTx tx, IndexSerializer serializer) {
        Preconditions.checkNotNull((Object)tx);
        Preconditions.checkNotNull((Object)serializer);
        this.tx = tx;
        this.serializer = serializer;
        this.constraints = new ArrayList<PredicateCondition<String, TitanElement>>(5);
    }

    private GraphCentricQueryBuilder has(String key, TitanPredicate predicate, Object condition) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)predicate);
        Preconditions.checkArgument((boolean)predicate.isValidCondition(condition), (String)"Invalid condition: %s", (Object[])new Object[]{condition});
        this.constraints.add(new PredicateCondition(key, predicate, condition));
        return this;
    }

    @Override
    public GraphCentricQueryBuilder has(String key, Predicate predicate, Object condition) {
        Preconditions.checkNotNull((Object)key);
        TitanPredicate titanPredicate = TitanPredicate.Converter.convert(predicate);
        return this.has(key, titanPredicate, condition);
    }

    @Override
    public GraphCentricQueryBuilder has(PropertyKey key, TitanPredicate predicate, Object condition) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)predicate);
        return this.has(key.getName(), predicate, condition);
    }

    @Override
    public GraphCentricQueryBuilder has(String key) {
        return this.has(key, (TitanPredicate)Cmp.NOT_EQUAL, (Object)null);
    }

    @Override
    public GraphCentricQueryBuilder hasNot(String key) {
        return this.has(key, (TitanPredicate)Cmp.EQUAL, (Object)null);
    }

    @Override
    @Deprecated
    public <T extends Comparable<T>> GraphCentricQueryBuilder has(String s, T t, Query.Compare compare) {
        return this.has(s, (Predicate)compare, t);
    }

    @Override
    public GraphCentricQueryBuilder has(String key, Object value) {
        return this.has(key, (TitanPredicate)Cmp.EQUAL, value);
    }

    @Override
    public GraphCentricQueryBuilder hasNot(String key, Object value) {
        return this.has(key, (TitanPredicate)Cmp.NOT_EQUAL, value);
    }

    @Override
    public <T extends Comparable<?>> GraphCentricQueryBuilder interval(String s, T t1, T t2) {
        this.has(s, (TitanPredicate)Cmp.GREATER_THAN_EQUAL, (Object)t1);
        return this.has(s, (TitanPredicate)Cmp.LESS_THAN, (Object)t2);
    }

    @Override
    public GraphCentricQueryBuilder limit(int limit) {
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0, (String)"Non-negative limit expected: %s", (Object[])new Object[]{limit});
        this.limit = limit;
        return this;
    }

    @Override
    public GraphCentricQueryBuilder orderBy(String key, Order order) {
        return this.orderBy(this.tx.getPropertyKey(key), order);
    }

    @Override
    public GraphCentricQueryBuilder orderBy(PropertyKey key, Order order) {
        Preconditions.checkArgument((boolean)Comparable.class.isAssignableFrom(key.getDataType()), (String)"Can only order on keys with comparable data type. [%s] has datatype [%s]", (Object[])new Object[]{key.getName(), key.getDataType()});
        Preconditions.checkArgument((key.getCardinality() == Cardinality.SINGLE ? 1 : 0) != 0, (String)"Ordering is undefined on multi-valued key [%s]", (Object[])new Object[]{key.getName()});
        Preconditions.checkArgument((!this.orders.containsKey(key) ? 1 : 0) != 0);
        this.orders.add(key, order);
        return this;
    }

    @Override
    public Iterable<Vertex> vertices() {
        GraphCentricQuery query = this.constructQuery(ElementCategory.VERTEX);
        return Iterables.filter(new QueryProcessor<GraphCentricQuery, TitanElement, JointIndexQuery>(query, this.tx.elementProcessor), Vertex.class);
    }

    @Override
    public Iterable<Edge> edges() {
        GraphCentricQuery query = this.constructQuery(ElementCategory.EDGE);
        return Iterables.filter(new QueryProcessor<GraphCentricQuery, TitanElement, JointIndexQuery>(query, this.tx.elementProcessor), Edge.class);
    }

    @Override
    public Iterable<TitanProperty> properties() {
        GraphCentricQuery query = this.constructQuery(ElementCategory.PROPERTY);
        return Iterables.filter(new QueryProcessor<GraphCentricQuery, TitanElement, JointIndexQuery>(query, this.tx.elementProcessor), TitanProperty.class);
    }

    private QueryDescription describe(ElementCategory category) {
        return new StandardQueryDescription(1, this.constructQuery(category));
    }

    @Override
    public QueryDescription describeForVertices() {
        return this.describe(ElementCategory.VERTEX);
    }

    @Override
    public QueryDescription describeForEdges() {
        return this.describe(ElementCategory.EDGE);
    }

    @Override
    public QueryDescription describeForProperties() {
        return this.describe(ElementCategory.PROPERTY);
    }

    public GraphCentricQuery constructQuery(final ElementCategory resultType) {
        BackendQueryHolder<JointIndexQuery> query;
        Preconditions.checkNotNull((Object)((Object)resultType));
        if (this.limit == 0) {
            return GraphCentricQuery.emptyQuery(resultType);
        }
        And<TitanElement> conditions = QueryUtil.constraints2QNF(this.tx, this.constraints);
        if (conditions == null) {
            return GraphCentricQuery.emptyQuery(resultType);
        }
        this.orders.makeImmutable();
        if (this.orders.isEmpty()) {
            this.orders = OrderList.NO_ORDER;
        }
        final HashSet indexCandidates = new HashSet();
        ConditionUtil.traversal(conditions, new com.google.common.base.Predicate<Condition<TitanElement>>(){

            public boolean apply(@Nullable Condition<TitanElement> condition) {
                if (condition instanceof PredicateCondition) {
                    RelationType type = (RelationType)((PredicateCondition)condition).getKey();
                    Preconditions.checkArgument((type != null && type.isPropertyKey() ? 1 : 0) != 0);
                    Iterables.addAll((Collection)indexCandidates, (Iterable)Iterables.filter(((InternalRelationType)type).getKeyIndexes(), (com.google.common.base.Predicate)new com.google.common.base.Predicate<IndexType>(){

                        public boolean apply(@Nullable IndexType indexType) {
                            return indexType.getElement() == resultType;
                        }
                    }));
                }
                return true;
            }
        });
        JointIndexQuery jointQuery = new JointIndexQuery();
        boolean isSorted = this.orders.isEmpty();
        HashSet coveredClauses = Sets.newHashSet();
        while (true) {
            IndexType bestCandidate = null;
            double candidateScore = 0.0;
            HashSet candidateSubcover = null;
            boolean candidateSupportsSort = false;
            Object candidateSubcondition = null;
            for (IndexType index : indexCandidates) {
                Object subcondition;
                HashSet subcover = Sets.newHashSet();
                boolean supportsSort = this.orders.isEmpty();
                if (index.hasSchemaTypeConstraint()) {
                    TitanSchemaType type = index.getSchemaTypeConstraint();
                    boolean matchesTypeConstraint = false;
                    for (PredicateCondition<RelationType, TitanElement> atom : GraphCentricQueryBuilder.getEqualityPredicateConditions(conditions)) {
                        if (!atom.getKey().equals(ImplicitKey.LABEL) || !type.getName().equals((String)atom.getValue())) continue;
                        matchesTypeConstraint = true;
                        subcover.add(atom);
                    }
                    if (!matchesTypeConstraint) continue;
                }
                if (index.isCompositeIndex()) {
                    subcondition = GraphCentricQueryBuilder.indexCover((CompositeIndexType)index, conditions, subcover);
                } else {
                    subcondition = GraphCentricQueryBuilder.indexCover((MixedIndexType)index, conditions, this.serializer, subcover);
                    if (coveredClauses.isEmpty() && !supportsSort && GraphCentricQueryBuilder.indexCoversOrder((MixedIndexType)index, this.orders)) {
                        supportsSort = true;
                    }
                }
                if (subcondition == null) continue;
                assert (!subcover.isEmpty());
                double score = 0.0;
                boolean coversAdditionalClause = false;
                for (Condition c : subcover) {
                    double s;
                    double d = s = c instanceof PredicateCondition && ((PredicateCondition)c).getPredicate() == Cmp.EQUAL ? 4.0 : 1.0;
                    if (coveredClauses.contains(c)) {
                        s *= 0.1;
                    } else {
                        coversAdditionalClause = true;
                    }
                    score += s;
                    if (!index.isCompositeIndex()) continue;
                    score += ((CompositeIndexType)index).getCardinality() == Cardinality.SINGLE ? 1000.0 : 1000.0;
                }
                if (supportsSort) {
                    score += 2.0;
                }
                if (!coversAdditionalClause || !(score > candidateScore)) continue;
                candidateScore = score;
                bestCandidate = index;
                candidateSubcover = subcover;
                candidateSubcondition = subcondition;
                candidateSupportsSort = supportsSort;
            }
            if (bestCandidate == null) break;
            if (coveredClauses.isEmpty()) {
                isSorted = candidateSupportsSort;
            }
            coveredClauses.addAll(candidateSubcover);
            if (bestCandidate.isCompositeIndex()) {
                jointQuery.add((CompositeIndexType)bestCandidate, this.serializer.getQuery((CompositeIndexType)bestCandidate, (Object[])candidateSubcondition));
                continue;
            }
            jointQuery.add((MixedIndexType)bestCandidate, this.serializer.getQuery((MixedIndexType)bestCandidate, (Condition)candidateSubcondition, this.orders));
        }
        if (!coveredClauses.isEmpty()) {
            int indexLimit = this.limit == Integer.MAX_VALUE ? 100 : Math.min(20000, this.limit);
            indexLimit = Math.min(50000, QueryUtil.adjustLimitForTxModifications(this.tx, coveredClauses.size(), indexLimit));
            jointQuery.setLimit(indexLimit);
            query = new BackendQueryHolder<JointIndexQuery>(jointQuery, coveredClauses.size() == conditions.numChildren(), isSorted, null);
        } else {
            query = new BackendQueryHolder<JointIndexQuery>(new JointIndexQuery(), false, isSorted, null);
        }
        return new GraphCentricQuery(resultType, conditions, this.orders, query, this.limit);
    }

    public static final boolean indexCoversOrder(MixedIndexType index, OrderList orders) {
        for (int i = 0; i < orders.size(); ++i) {
            if (index.indexesKey(orders.getKey(i))) continue;
            return false;
        }
        return true;
    }

    public static final Object[] indexCover(CompositeIndexType index, Condition<TitanElement> condition, Set<Condition> covered) {
        assert (QueryUtil.isQueryNormalForm(condition));
        assert (condition instanceof And);
        if (index.getStatus() != SchemaStatus.ENABLED) {
            return null;
        }
        IndexField[] fields = index.getFieldKeys();
        Object[] indexCover = new Object[fields.length];
        Condition[] coveredClauses = new Condition[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            IndexField field = fields[i];
            for (PredicateCondition<RelationType, TitanElement> atom : GraphCentricQueryBuilder.getEqualityPredicateConditions(condition)) {
                if (!atom.getKey().equals(field.getFieldKey())) continue;
                indexCover[i] = atom.getValue();
                coveredClauses[i] = atom;
            }
            if (indexCover[i] != null) continue;
            return null;
        }
        assert (indexCover != null);
        covered.addAll(Arrays.asList(coveredClauses));
        return indexCover;
    }

    private static final Iterable<PredicateCondition<RelationType, TitanElement>> getEqualityPredicateConditions(Condition<TitanElement> condition) {
        return Iterables.filter(condition.getChildren(), (com.google.common.base.Predicate)new com.google.common.base.Predicate<Condition<TitanElement>>(){

            public boolean apply(@Nullable Condition<TitanElement> subclause) {
                if (!(subclause instanceof PredicateCondition)) {
                    return false;
                }
                PredicateCondition atom = (PredicateCondition)subclause;
                return atom.getPredicate() == Cmp.EQUAL && atom.getValue() != null;
            }
        });
    }

    public static final Condition<TitanElement> indexCover(MixedIndexType index, Condition<TitanElement> condition, IndexSerializer indexInfo, Set<Condition> covered) {
        assert (QueryUtil.isQueryNormalForm(condition));
        assert (condition instanceof And);
        And<TitanElement> subcondition = new And<TitanElement>(condition.numChildren());
        for (Condition<TitanElement> subclause : condition.getChildren()) {
            if (!GraphCentricQueryBuilder.coversAll(index, subclause, indexInfo)) continue;
            subcondition.add(subclause);
            covered.add(subclause);
        }
        return subcondition.isEmpty() ? null : subcondition;
    }

    private static final boolean coversAll(MixedIndexType index, Condition<TitanElement> condition, IndexSerializer indexInfo) {
        if (condition.getType() == Condition.Type.LITERAL) {
            if (!(condition instanceof PredicateCondition)) {
                return false;
            }
            PredicateCondition atom = (PredicateCondition)condition;
            if (atom.getValue() == null) {
                return false;
            }
            Preconditions.checkArgument((boolean)((RelationType)atom.getKey()).isPropertyKey());
            PropertyKey key = (PropertyKey)atom.getKey();
            ParameterIndexField[] fields = index.getFieldKeys();
            ParameterIndexField match = null;
            for (int i = 0; i < fields.length; ++i) {
                if (fields[i].getStatus() != SchemaStatus.ENABLED || !fields[i].getFieldKey().equals(key)) continue;
                match = fields[i];
            }
            if (match == null) {
                return false;
            }
            return indexInfo.supports(index, match, atom.getPredicate());
        }
        for (Condition<TitanElement> child : condition.getChildren()) {
            if (GraphCentricQueryBuilder.coversAll(index, child, indexInfo)) continue;
            return false;
        }
        return true;
    }
}

